% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EXTILindley.R
\name{EXTILindley}
\alias{EXTILindley}
\alias{dextilindley}
\alias{hextilindley}
\alias{pextilindley}
\alias{qextilindley}
\alias{rextilindley}
\title{Extended Inverse Lindley Distribution}
\source{
[dpqh]extilindley are calculated directly from the definitions. \code{rextilindley} uses either a two-component mixture of the inverse generalized gamma distributions or the inverse transform method.
}
\usage{
dextilindley(x, theta, alpha, beta, log = FALSE)

pextilindley(q, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qextilindley(p, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

rextilindley(n, theta, alpha, beta, mixture = TRUE)

hextilindley(x, theta, alpha, beta, log = TRUE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha, beta}{positive parameters.}

\item{log, log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical. If TRUE (default) \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical. If TRUE (default), random values are generated from a two-component mixture of inverse generalized gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dextilindley} gives the density, \code{pextilindley} gives the distribution function, \code{qextilindley} gives the quantile function, \code{rextilindley} generates random deviates and \code{hextilindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random numbers generation and hazard rate function for the extended inverse Lindley distribution with parameters theta, alpha and beta.
}
\details{
Probability density function
\deqn{f(x\mid \theta,\alpha,\beta )=\frac{\alpha \theta ^{2}}{\theta +\beta }\left( \frac{\beta +x^{\alpha }}{x^{2\alpha +1}}\right) e^{-\frac{\theta }{x^{\alpha }}}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha,\beta )=\left( 1+\frac{\theta \beta }{\left(\theta +\beta \right) {x}^{\alpha }}\right) e{{^{-{\frac{\theta }{x^{\alpha }}}}}}}

Quantile function
\deqn{Q\left( p\mid \theta,\alpha,\beta \right)=\left[ -\frac{1}{\theta }-\frac{1}{\beta }-\frac{1}{\theta }W_{-1}{\left( -p{\frac{\left( \theta +\beta \right) }{\beta }e{^{-\left( {\frac{\theta +\beta }{\beta }}\right) }}}\right) }\right] ^{-\frac{1}{\alpha }}}

Hazard rate function
\deqn{h(x\mid \theta,\alpha,\beta )=\frac{\alpha \theta ^{2}\left( \beta+x^{\alpha }\right) e^{-\frac{\theta }{x^{\alpha }}}}{\left( \theta +\beta\right) x^{2\alpha +1}\left[ 1-\left( 1+\frac{\theta \beta }{\left( \theta+\beta \right) {x}^{\alpha }}\right) e{{^{-{\frac{\theta }{x^{\alpha }}}}}}\right] }}

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.
}
\examples{
set.seed(1)
x <- rextilindley(n = 1000, theta = 10, alpha = 10, beta = 10, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dextilindley(S, theta = 10, alpha = 10, beta = 10), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', breaks = seq(0, R[2] + 1, 0.1), add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pextilindley(q, theta = 10, alpha = 10, beta = 10, lower.tail = TRUE)
pextilindley(q, theta = 10, alpha = 10, beta = 10, lower.tail = FALSE)
qextilindley(p, theta = 10, alpha = 10, beta = 10, lower.tail = TRUE)
qextilindley(p, theta = 10, alpha = 10, beta = 10, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'extilindley', start = list(theta = 10, alpha = 10, beta = 10))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Alkarni, S. H., (2015). Extended inverse Lindley distribution: properties and application. \emph{SpringerPlus}, \bold{4}, (1), 690-703.
}
\seealso{
\code{\link[LambertW]{W}}, \code{\link[VGAM]{gengamma.stacy}}.
}

