% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCorrLoadings.R
\name{makeCorrLoadings}
\alias{makeCorrLoadings}
\title{Correlation matrix from item factor loadings}
\usage{
makeCorrLoadings(
  loadings,
  factorCor = NULL,
  uniquenesses = NULL,
  nearPD = FALSE
)
}
\arguments{
\item{loadings}{(numeric matrix) \strong{k} (items) by \strong{f} (factors)
matrix of \strong{standardised} factor loadings. Item names and Factor names
are taken from the row_names (items) and the column_names (factors),
if present.

@note
"Censored" loadings (for example, where loadings less than '0.30' are
removed for clarity) tend to severely reduce the accuracy of the
\code{makeCorrLoadings()} function. For a detailed demonstration, see the file
\strong{makeCorrLoadings_Validate.pdf} in the package website on GitHub.}

\item{factorCor}{(numeric matrix) \strong{f} x \strong{f} factor correlation matrix}

\item{uniquenesses}{(numeric vector) length \strong{k} vector of uniquenesses.
If \emph{NULL}, the default, compute from the calculated communalities.}

\item{nearPD}{(logical) If TRUE, project factorCor and the final
correlation matrix onto nearest Positive Definite matrix, if needed.}
}
\value{
Correlation matrix of inter-item correlations
}
\description{
\code{makeCorrLoadings()} generates a correlation matrix of
inter-item correlations based on item factor loadings as might be seen in
\emph{Exploratory Factor Analysis} (\strong{EFA}) or a \emph{Structural Equation Model}
(\strong{SEM}).

Such a correlation matrix can be applied to the \code{makeItems()}
function to generate synthetic data with those predefined factor structures.
}
\note{
The \emph{nearPD} option applies the \emph{Matrix::nearPD()} function to force
a non-positive-definite matrix to be positive-definite.
It should be used only when a matrix is "nearly" PD.
In most cases, a non-PD matrix that appears in the makeCorrLoadings()
function means that there is a problem with the input parameters.
}
\examples{

# Example loadings
factorLoadings <- matrix(
  c(
    0.05, 0.20, 0.70,
    0.10, 0.05, 0.80,
    0.05, 0.15, 0.85,
    0.20, 0.85, 0.15,
    0.05, 0.85, 0.10,
    0.10, 0.90, 0.05,
    0.90, 0.15, 0.05,
    0.80, 0.10, 0.10
  ),
  nrow = 8, ncol = 3, byrow = TRUE
)

# row and column names
rownames(factorLoadings) <- c("Q1", "Q2", "Q3", "Q4", "Q5", "Q6", "Q7", "Q8")
colnames(factorLoadings) <- c("Factor1", "Factor2", "Factor3")

# Factor correlation matrix
factorCor <- matrix(
  c(
    1.0,  0.7, 0.6,
    0.7,  1.0, 0.4,
    0.6,  0.4, 1.0
  ),
  nrow = 3, byrow = TRUE
)

# Apply the function
itemCorrelations <- makeCorrLoadings(factorLoadings, factorCor)

round(itemCorrelations, 3)

}
