% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_function.R
\name{sim_function}
\alias{sim_function}
\title{Empirical p-value for cointegration test}
\usage{
sim_function(
  N = NULL,
  tau = NULL,
  stat_value = NULL,
  k = 1,
  r = 1,
  fin_sample_corr = FALSE,
  sim_num = 1000
)
}
\arguments{
\item{N}{The number of time series used in simulations.}

\item{tau}{The length of the time series used in simulations.}

\item{stat_value}{The test statistic value for which the p-value is calculated.}

\item{k}{The number of lags that we wish to employ in the vector autoregression. The default value is k = 1.}

\item{r}{The number of largest eigenvalues used in the test. The default value is r = 1.}

\item{fin_sample_corr}{A boolean variable indicating whether we wish to employ finite sample correction on our test statistics. The default value is fin_sample_corr = FALSE.}

\item{sim_num}{The number of simulations that the function conducts for H0. The default value is sim_num = 1000.}
}
\value{
A list that contains the simulation values, the empirical percentage (realizations larger than the test statistic provided by the user) and a histogram.
}
\description{
Runs a simulation on the H0 for the Bykhovskaya-Gorin test for cointegration and returns an empirical p-value. Paper can be found at: https://doi.org/10.48550/arXiv.2202.07150
}
\examples{
sim_function(N=90, tau=501, stat_value=-0.27,k=1,r=1,sim_num=30)
}
