\name{plot.demonoid}
\alias{plot.demonoid}
\title{Plot samples from the output of \code{LaplacesDemon}}
\description{
  This may be used to plot, or save plots of, samples in an object of
  class \code{demonoid}. Plots include a trace plot, density plot, 
  autocorrelation or ACF plot, and if an adaptive algorithm was used,
  the absolute difference in the proposal variance across adaptations.
}
\usage{\method{plot}{demonoid}(x, BurnIn=1, Data, PDF=FALSE, Parms, \dots)}
\arguments{
     \item{x}{
     This required argument is an object of class \code{demonoid}.
     } 
     \item{BurnIn}{
     This argument requires a positive integer that indicates a 
     number of iterations to discard as burn-in for the purposes of
     plotting.
     }
     \item{Data}{
     This required argument must receive the list of data that
     was supplied to \code{LaplacesDemon} to create the object of
     class \code{demonoid}.
     }
     \item{PDF}{
     This logical argument indicates whether or not the user wants
     Laplace's Demon to save the plots as a .pdf file.
     }
     \item{Parms}{
     This argument accepts a vector of quoted strings to be matched for
     selecting parameters for plotting. This argument defaults to
     \code{NULL} and selects every parameter for plotting. Each quoted
     string is matched to one or more parameter names with the
     \code{grep} function. For example, if the user specifies
     \code{Parms=c("eta","tau")}, and if the parameter names
     are beta[1], beta[2], eta[1], eta[2], and tau, then all parameters
     will be selected, because the string \code{eta} is within \code{beta}.
     }
     \item{\dots}{Additional arguments are unused.}
   }
\details{
  The plots are arranged in a 3 x 3 matrix. Each row represents a
  parameter, the deviance, or a monitored variable. The left column
  displays trace plots, the middle column displays kernel density
  plots, and the right column displays autocorrelation (ACF) plots.

  Trace plots show the thinned history of the chain or Markov chain,
  with its value in the y-axis moving by iteration across the x-axis.
  A chain or Markov chain with good properties does not suggest a trend
  upward or downward as it progresses across the x-axis (it should
  appear stationary), and it should mix well, meaning it should appear
  as though random samples are being taken each time from the same
  target distribution. Visual inspection of a trace plot cannot
  verify convergence, but apparent non-stationarity or poor mixing can
  certainly suggest non-convergence. A red, smoothed line also appears
  to aid visual inspection.

  Kernel density plots depict the marginal posterior distribution.
  There is no distributional assumption about this density.

  Autocorrelation plots show the autocorrelation or serial correlation
  between sampled values at nearby iterations. Samples with
  autocorrelation do not violate any assumption, but are inefficient
  because they reduce the effective sample size (ESS), and indicate that
  the chain is not mixing well, since each value is influenced by values
  that are previous and nearby. The x-axis indicates lags with respect
  to samples by iteration, and the y-axis represents autocorrelation.
  The ideal autocorrelation plot shows perfect correlation at zero lag,
  and quickly falls to zero autocorrelation for all other lags.

  If an adaptive algorithm was used, then the distribution of absolute
  differences in the proposal variances is plotted across each
  adaptation. The proposal variance should change less as the adaptive
  algorithm approaches the target distributions.  The following
  quantiles are plotted: 0.025, 0.500, and 0.975.
}
\references{\url{http://www.statisticat.com/laplacesdemon.html}}
\author{Byron Hall \email{laplacesdemon@statisticat.com}}
\seealso{\code{\link{LaplacesDemon}}}
\examples{### See the LaplacesDemon function for an example.}
\keyword{plot}