\name{apply.LTR}
\alias{apply.LTR}
\title{Apply a fitted LTR model to a new dataset}
\description{Map a gene-expression matrix into the space encoded by a linear-tranformation of replicates (LTR) fit object.}
\usage{apply.LTR(x, model.fit);}
\arguments{
  \item{x}{A matrix with samples as columns and genes as rows; must have the same number of rows as the model in model.fit}
  \item{model.fit}{A list with components rownames, intercepts, slopes, r.squared, and residuals. Exactly such a list is generated by fit.LTR}
}
\details{x must have the same number of rows (and in the same order) as the components of model.fit -- no validation of this is performed.}
\value{A gene-expression matrix of dim(x) in the space of model.fit}
\references{The LTR paper, once published}
\author{Paul C. Boutros}
\examples{
x <- matrix(nrow = 100, ncol = 10, data = rnorm(1000));
y <- matrix(nrow = 100, ncol = 10, data = rnorm(1000));
model.fit <- fit.LTR(x, y);

z <- apply.LTR(
	x = y + matrix(nrow = 100, ncol = 10, data = rnorm(1000) / 10),
	model.fit = model.fit
	);
}
\keyword{models}
