% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll_lnormparmix.R
\name{ll_lnormparmix}
\alias{ll_lnormparmix}
\title{Log-likelihood with respect to xmin}
\usage{
ll_lnormparmix(x, pi, mu, sigma, alpha, y)
}
\arguments{
\item{x}{positive scalar: value of xmin where the function is evaluated.}

\item{pi}{scalar, 0 < pi < 1: mixing weight.}

\item{mu}{scalar: expected value of the lognormal distribution on the log scale.}

\item{sigma}{positive scalar: standard deviation of the lognormal distribution on the log scale.}

\item{alpha}{non-negative scalar: Pareto shape parameter.}

\item{y}{(nx1) vector: random sample from the mixture.}
}
\value{
ll numerical value of the log-likelihood function.
}
\description{
This function evaluates the log-likelihood function with respect to xmin for a mixture of a lognormal and a Pareto r.v.,
assuming to know the numerical values of all the other parameters.
}
\examples{
y <- rLnormParMix(100,.5,0,1,4,1.5)
llMix <- ll_lnormparmix(5,.5,0,1,4,y)
}
\keyword{mixture.}
