% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{llm_config}
\alias{llm_config}
\title{Create LLM Configuration}
\usage{
llm_config(provider, model, api_key, ...)
}
\arguments{
\item{provider}{A string specifying the API provider. Supported providers include:
"openai" for OpenAI,
"anthropic" for Anthropic,
"groq" for Groq,
"together" for Together AI;
This configuration is extendable; to add support for additional providers, define a new S3 method for `call_llm` corresponding to the provider.}

\item{model}{The model name to use. This depends on the provider. For example:
OpenAI: "gpt-4o-mini",
Anthropic: "claude-3-opus-20240229",
Groq: "llama-3.1-8b-instant",
Together AI: "meta-llama/Meta-Llama-3.1-8B-Instruct-Turbo".}

\item{api_key}{Your API key for the provider.}

\item{...}{Additional model-specific parameters (e.g., `temperature`, `max_tokens`).}
}
\value{
An object of class `llm_config` containing API and model parameters.
}
\description{
Creates a configuration object for interacting with a specified LLM API provider.
}
\examples{
\dontrun{
  # Obtain API keys from:
  # OpenAI: https://platform.openai.com/api-keys
  # Groq: https://console.groq.com/keys
  # Anthropic: https://console.anthropic.com/settings/keys
  # Together AI: https://api.together.ai/settings/api-keys

  # ----- OpenAI Example -----
  openai_config <- llm_config(
    provider = "openai",
    model = "gpt-4o-mini",
    api_key = OPENAI_KEY,
    temperature = 0.7,
    max_tokens = 500
  )

  # ----- Anthropic Example -----
  anthropic_config <- llm_config(
    provider = "anthropic",
    model = "claude-3-opus-20240229",
    api_key = ANTHROPIC_API_KEY,
    max_tokens = 500
  )

  # ----- Groq Example -----
  groq_config <- llm_config(
    provider = "groq",
    model = "llama-3.1-8b-instant",
    api_key = GROQ_API_KEY,
    temperature = 0.3,
    max_tokens = 1000
  )

  # ----- Together AI Example -----
  together_config <- llm_config(
    provider = "together",
    model = "meta-llama/Meta-Llama-3.1-8B-Instruct-Turbo",
    api_key = TOGETHER_KEY,
    temperature = 0.5,
    max_tokens = 1000
  )

  # This configuration is extendable by defining new `call_llm` methods for additional providers.
}

}
\seealso{
\code{\link{call_llm}}
}
