% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLHD.L2009.R
\name{OLHD.L2009}
\alias{OLHD.L2009}
\title{Orthogonal Latin Hypercube Design}
\usage{
OLHD.L2009(OLHD, OA)
}
\arguments{
\item{OLHD}{An orthogonal Latin hypercube design with run size \code{n} and factor size \code{p}, and it will be coupled with the input orthogonal array.}

\item{OA}{An orthogonal array, with \code{n^2} rows, \code{2f} columns, \code{n} symbols, strength two and index unity is available, which can be denoted as \code{OA(n^2,2f,n,2)}.}
}
\value{
If all inputs are logical, e,g. a \code{n} by \code{p} orthogonal Latin hypercube design and an \code{OA(n^2,2f,n,2)} orthogonal array, then the output will be an orthogonal Latin hypercube design with the following run size: \code{n^2} and the following factor size: \code{2fp}.
}
\description{
\code{OLHD.L2009} returns a \code{n^2} by \code{2fp} orthogonal Latin hypercube design generated by the construction method of Lin et al. (2009)
}
\examples{
#create a 5 by 2 OLHD
OLHD=OLHD.C2007(m=2)

#create an OA(25,6,5,2)
OA=matrix(c(2,2,2,2,2,1,2,1,5,4,3,5,3,2,1,5,4,5,1,5,4,3,2,5,
4,1,3,5,2,3,1,2,3,4,5,2,1,3,5,2,4,3,1,1,1,1,1,1,4,3,2,1,5,5,
5,5,5,5,5,1,4,4,4,4,4,1,3,1,4,2,5,4,3,3,3,3,3,1,3,5,2,4,1,3,
3,4,5,1,2,2,5,4,3,2,1,5,2,3,4,5,1,2,2,5,3,1,4,4,1,4,2,5,3,4,
4,2,5,3,1,4,2,4,1,3,5,3,5,3,1,4,2,4,5,2,4,1,3,3,5,1,2,3,4,2,
4,5,1,2,3,2),ncol=6,nrow=25,byrow=TRUE)

#Construct a 25 by 12 OLHD
OLHD.L2009(OLHD,OA)

}
\references{
Lin, C.D., Mukerjee, R., and Tang, B. (2009) Construction of orthogonal and nearly orthogonal Latin hypercubes. \emph{Biometrika}, \strong{96}(1), 243-247.
}
