% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPchip.R
\name{SNPchip}
\alias{SNPchip}
\title{Find commercial genotyping chip arrays for variants of interest.}
\usage{
SNPchip(
  snps,
  chip = "ALL",
  token = NULL,
  file = FALSE,
  genome_build = "grch37",
  api_root = "https://ldlink.nci.nih.gov/LDlinkRest"
)
}
\arguments{
\item{snps}{between 1 - 5,000 variants, using an rsID or chromosome coordinate (e.g. "chr7:24966446")}

\item{chip}{chip or arrays, platform code(s) for a SNP chip array, ALL_Illumina, ALL_Affy or ALL, default=ALL}

\item{token}{LDlink provided user token, default = NULL, register for token at  \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}

\item{genome_build}{Choose between one of the three options...`grch37` for genome build GRCh37 (hg19),
`grch38` for GRCh38 (hg38), or `grch38_high_coverage` for GRCh38 High Coverage (hg38) 1000 Genome Project
data sets.  Default is GRCh37 (hg19).}

\item{api_root}{Optional alternative root url for API.}
}
\value{
a data frame
}
\description{
Find commercial genotyping chip arrays for variants of interest.
}
\examples{
\dontrun{SNPchip(c("rs3", "rs4", "rs148890987"), "ALL",
                 token = Sys.getenv("LDLINK_TOKEN"))
               }
\dontrun{SNPchip(c("rs3", "rs4", "rs148890987"),
                 c("A_CHB2", "A_SNP5.0"),
                 token = Sys.getenv("LDLINK_TOKEN"))
                 }
\dontrun{SNPchip("rs148890987", "ALL_Affy", token = Sys.getenv("LDLINK_TOKEN"))}

}
