% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWO.R
\name{PWO}
\alias{PWO}
\title{Calculate the pairwise-order (PWO) of an order-of-addition design}
\usage{
PWO(X)
}
\arguments{
\item{X}{A matrix object. \code{X} must be an order-of-addition design (OofA) matrix.}
}
\value{
If the input is logical, then the output will be a \code{n} by \code{{k \\choose 2}} matrix, where \code{n} and \code{k} are the run size and factor size of the input OofA. Each column of PWO represents one distinct pair of elements from the input OofA. For example, an OofA with 4 factors has the following pairs: \{(1,2),(1,3),(1,4),(2,3),(2,4),(3,4)\}.
}
\description{
\code{PWO} returns the pairwise-order matrix of an order-of-addition design
}
\examples{
#create a full OofA with 3 factors.
toy=rOofA(k=3);toy

#Calculate the pairwise-order of toy 
PWO(X=toy)
}
\references{
Van Nostrand, R. C. (1995) Design of experiments where the order of addition is important. \emph{ASA proceedings of the Section on Physical and Engineering Sciences}, 155-160.
}
