/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.hannanum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kr.ac.kaist.swrc.jhannanum.comm.CommObject;
import kr.ac.kaist.swrc.jhannanum.comm.PlainSentence;
import kr.ac.kaist.swrc.jhannanum.comm.Sentence;
import kr.ac.kaist.swrc.jhannanum.comm.SetOfSentences;
import kr.ac.kaist.swrc.jhannanum.exception.ResultTypeException;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.MorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.PosTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.MorphemeProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.PlainTextProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.PosProcessor;
import kr.ac.kaist.swrc.jhannanum.thread.MorphAnalyzerThread;
import kr.ac.kaist.swrc.jhannanum.thread.MorphemeProcThread;
import kr.ac.kaist.swrc.jhannanum.thread.PlainTextProcThread;
import kr.ac.kaist.swrc.jhannanum.thread.PosProcThread;
import kr.ac.kaist.swrc.jhannanum.thread.PosTaggerThread;

public class Workflow {
    public static int MAX_SUPPLEMENT_PLUGIN_NUM = 8;
    private int maxSupplementPluginNum = 0;
    private boolean isThreadMode = false;
    private int outputPhaseNum = 0;
    private int outputQueueNum = 0;
    private LinkedList<Thread> threadList = null;
    private MorphAnalyzer morphAnalyzer = null;
    private String morphAnalyzerConfFile = null;
    private PosTagger posTagger = null;
    private String posTaggerConfFile = null;
    private PlainTextProcessor[] plainTextProcessors = null;
    private String[] plainTextProcessorsConfFiles = null;
    private int plainTextPluginCnt = 0;
    private MorphemeProcessor[] morphemeProcessors = null;
    private String[] morphemeProcessorsConfFiles = null;
    private int morphemePluginCnt = 0;
    private PosProcessor[] posProcessors = null;
    private String[] posProcessorConfFiles = null;
    private int posPluginCnt = 0;
    private boolean isInitialized = false;
    private String baseDir = null;
    ArrayList<LinkedBlockingQueue<PlainSentence>> queuePhase1 = null;
    ArrayList<LinkedBlockingQueue<SetOfSentences>> queuePhase2 = null;
    ArrayList<LinkedBlockingQueue<Sentence>> queuePhase3 = null;
    private String userDicFile;
    private String context;

    public Workflow() {
        this.maxSupplementPluginNum = MAX_SUPPLEMENT_PLUGIN_NUM;
        this.plainTextProcessors = new PlainTextProcessor[this.maxSupplementPluginNum];
        this.morphemeProcessors = new MorphemeProcessor[this.maxSupplementPluginNum];
        this.posProcessors = new PosProcessor[this.maxSupplementPluginNum];
        this.plainTextProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.morphemeProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.posProcessorConfFiles = new String[this.maxSupplementPluginNum];
        this.queuePhase1 = new ArrayList(this.maxSupplementPluginNum);
        this.queuePhase2 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.queuePhase3 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.threadList = new LinkedList();
        this.isInitialized = true;
        this.baseDir = ".";
    }

    public Workflow(String baseDir, String ctx) {
        this.maxSupplementPluginNum = MAX_SUPPLEMENT_PLUGIN_NUM;
        this.plainTextProcessors = new PlainTextProcessor[this.maxSupplementPluginNum];
        this.morphemeProcessors = new MorphemeProcessor[this.maxSupplementPluginNum];
        this.posProcessors = new PosProcessor[this.maxSupplementPluginNum];
        this.plainTextProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.morphemeProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.posProcessorConfFiles = new String[this.maxSupplementPluginNum];
        this.queuePhase1 = new ArrayList(this.maxSupplementPluginNum);
        this.queuePhase2 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.queuePhase3 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.threadList = new LinkedList();
        this.isInitialized = true;
        this.baseDir = baseDir;
        this.context = ctx;
    }

    public String getCtx() {
        return this.context;
    }

    public Workflow(String baseDir, int maxSupplementPluginNum) {
        this.maxSupplementPluginNum = maxSupplementPluginNum;
        this.plainTextProcessors = new PlainTextProcessor[maxSupplementPluginNum];
        this.morphemeProcessors = new MorphemeProcessor[maxSupplementPluginNum];
        this.posProcessors = new PosProcessor[maxSupplementPluginNum];
        this.plainTextProcessorsConfFiles = new String[maxSupplementPluginNum];
        this.morphemeProcessorsConfFiles = new String[maxSupplementPluginNum];
        this.posProcessorConfFiles = new String[maxSupplementPluginNum];
        this.queuePhase1 = new ArrayList(maxSupplementPluginNum);
        this.queuePhase2 = new ArrayList(maxSupplementPluginNum + 1);
        this.queuePhase3 = new ArrayList(maxSupplementPluginNum + 1);
        this.threadList = new LinkedList();
        this.isInitialized = true;
        this.baseDir = baseDir;
    }

    public void setMorphAnalyzer(MorphAnalyzer ma, String configFile) {
        this.morphAnalyzer = ma;
        this.morphAnalyzerConfFile = configFile;
    }

    public void setMorphUserDic(String userDicFile) {
        this.userDicFile = userDicFile;
    }

    public void setPosTagger(PosTagger tagger, String configFile) {
        this.posTagger = tagger;
        this.posTaggerConfFile = configFile;
    }

    public void appendPlainTextProcessor(PlainTextProcessor plugin, String configFile) {
        this.plainTextProcessorsConfFiles[this.plainTextPluginCnt] = configFile;
        this.plainTextProcessors[this.plainTextPluginCnt++] = plugin;
    }

    public void appendMorphemeProcessor(MorphemeProcessor plugin, String configFile) {
        this.morphemeProcessorsConfFiles[this.morphemePluginCnt] = configFile;
        this.morphemeProcessors[this.morphemePluginCnt++] = plugin;
    }

    public void appendPosProcessor(PosProcessor plugin, String configFile) {
        this.posProcessorConfFiles[this.posPluginCnt] = configFile;
        this.posProcessors[this.posPluginCnt++] = plugin;
    }

    public void activateWorkflow(boolean threadMode) throws Exception {
        if (threadMode) {
            this.isThreadMode = true;
            LinkedBlockingQueue<PlainSentence> in1 = null;
            LinkedBlockingQueue<PlainSentence> out1 = new LinkedBlockingQueue<PlainSentence>();
            this.queuePhase1.add(out1);
            int i = 0;
            while (i < this.plainTextPluginCnt) {
                in1 = out1;
                out1 = new LinkedBlockingQueue();
                this.queuePhase1.add(out1);
                this.plainTextProcessors[i].initialize(this.baseDir, this.plainTextProcessorsConfFiles[i]);
                this.threadList.add(new PlainTextProcThread(this.plainTextProcessors[i], in1, out1));
                ++i;
            }
            if (this.morphAnalyzer == null) {
                this.outputPhaseNum = 1;
                this.outputQueueNum = this.plainTextPluginCnt;
                this.runThreads();
                return;
            }
            in1 = out1;
            LinkedBlockingQueue<SetOfSentences> in2 = null;
            LinkedBlockingQueue<SetOfSentences> out2 = new LinkedBlockingQueue<SetOfSentences>();
            this.queuePhase2.add(out2);
            this.morphAnalyzer.initialize(this.baseDir, this.morphAnalyzerConfFile);
            this.morphAnalyzer.loadUserDic(this.userDicFile);
            this.threadList.add(new MorphAnalyzerThread(this.morphAnalyzer, in1, out2));
            int i2 = 0;
            while (i2 < this.morphemePluginCnt) {
                in2 = out2;
                out2 = new LinkedBlockingQueue();
                this.queuePhase2.add(out2);
                this.morphemeProcessors[i2].initialize(this.baseDir, this.morphemeProcessorsConfFiles[i2]);
                this.threadList.add(new MorphemeProcThread(this.morphemeProcessors[i2], in2, out2));
                ++i2;
            }
            if (this.posTagger == null) {
                this.outputPhaseNum = 2;
                this.outputQueueNum = this.morphemePluginCnt;
                this.runThreads();
                return;
            }
            in2 = out2;
            LinkedBlockingQueue<Sentence> in3 = null;
            LinkedBlockingQueue<Sentence> out3 = new LinkedBlockingQueue<Sentence>();
            this.posTagger.initialize(this.baseDir, this.posTaggerConfFile);
            this.queuePhase3.add(out3);
            this.threadList.add(new PosTaggerThread(this.posTagger, in2, out3));
            int i3 = 0;
            while (i3 < this.posPluginCnt) {
                in3 = out3;
                out3 = new LinkedBlockingQueue();
                this.queuePhase3.add(out3);
                this.posProcessors[i3].initialize(this.baseDir, this.posProcessorConfFiles[i3]);
                this.threadList.add(new PosProcThread(this.posProcessors[i3], in3, out3));
                ++i3;
            }
            this.outputPhaseNum = 3;
            this.outputQueueNum = this.posPluginCnt;
            this.runThreads();
        } else {
            this.isThreadMode = false;
            this.queuePhase1.add(new LinkedBlockingQueue());
            int i = 0;
            while (i < this.plainTextPluginCnt) {
                this.plainTextProcessors[i].initialize(this.baseDir, this.plainTextProcessorsConfFiles[i]);
                this.queuePhase1.add(new LinkedBlockingQueue());
                ++i;
            }
            if (this.morphAnalyzer == null) {
                this.outputPhaseNum = 1;
                this.outputQueueNum = this.plainTextPluginCnt;
                return;
            }
            this.morphAnalyzer.initialize(this.baseDir, this.morphAnalyzerConfFile);
            this.morphAnalyzer.loadUserDic(this.userDicFile);
            this.queuePhase2.add(new LinkedBlockingQueue());
            i = 0;
            while (i < this.morphemePluginCnt) {
                this.morphemeProcessors[i].initialize(this.baseDir, this.morphemeProcessorsConfFiles[i]);
                this.queuePhase2.add(new LinkedBlockingQueue());
                ++i;
            }
            if (this.posTagger == null) {
                this.outputPhaseNum = 2;
                this.outputQueueNum = this.morphemePluginCnt;
                return;
            }
            this.posTagger.initialize(this.baseDir, this.posTaggerConfFile);
            this.queuePhase3.add(new LinkedBlockingQueue());
            i = 0;
            while (i < this.posPluginCnt) {
                this.posProcessors[i].initialize(this.baseDir, this.posProcessorConfFiles[i]);
                this.queuePhase3.add(new LinkedBlockingQueue());
                ++i;
            }
            this.outputPhaseNum = 3;
            this.outputQueueNum = this.posPluginCnt;
        }
    }

    private void runThreads() {
        for (Thread th : this.threadList) {
            th.start();
        }
    }

    public void close() {
        if (this.isThreadMode) {
            for (Thread th : this.threadList) {
                th.interrupt();
            }
            this.threadList.clear();
        }
    }

    public void clear() {
        this.close();
        if (this.isInitialized) {
            this.queuePhase1.clear();
            this.queuePhase2.clear();
            this.queuePhase3.clear();
            this.isThreadMode = false;
            this.outputPhaseNum = 0;
            this.outputQueueNum = 0;
            this.plainTextPluginCnt = 0;
            this.morphemePluginCnt = 0;
            this.posPluginCnt = 0;
            if (this.morphAnalyzer != null) {
                this.morphAnalyzer.shutdown();
                this.morphAnalyzer = null;
            }
            if (this.posTagger != null) {
                this.posTagger.shutdown();
                this.posTagger = null;
            }
        }
    }

    public void analyze(String document) {
        String[] strArray = document.split("\n");
        LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(0);
        if (queue == null) {
            return;
        }
        int i = 0;
        while (i < strArray.length - 1) {
            queue.add(new PlainSentence(0, i, false, strArray[i].trim()));
            ++i;
        }
        queue.add(new PlainSentence(0, strArray.length - 1, true, strArray[strArray.length - 1].trim()));
        if (!this.isThreadMode) {
            this.analyzeInSingleThread();
        }
    }

    public void analyze(File document) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(document));
        LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(0);
        if (queue == null) {
            return;
        }
        String line = null;
        int i = 0;
        while ((line = br.readLine()) != null) {
            if (br.ready()) {
                queue.add(new PlainSentence(0, i++, false, line.trim()));
                continue;
            }
            queue.add(new PlainSentence(0, i++, true, line.trim()));
            break;
        }
        br.close();
        if (!this.isThreadMode) {
            this.analyzeInSingleThread();
        }
    }

    public <T> T getResultOfSentence(T a) throws ResultTypeException {
        block8: {
            Class<?> objClass = a.getClass();
            try {
                if (PlainSentence.class.equals(objClass)) {
                    if (this.outputPhaseNum != 1) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                if (SetOfSentences.class.equals(objClass)) {
                    if (this.outputPhaseNum != 2) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<SetOfSentences> queue = this.queuePhase2.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                if (Sentence.class.equals(objClass)) {
                    if (this.outputPhaseNum != 3) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<Sentence> queue = this.queuePhase3.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                throw new ResultTypeException(this.outputPhaseNum);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return a;
    }

    public String getResultOfSentence() {
        String res = null;
        try {
            switch (this.outputPhaseNum) {
                case 1: {
                    LinkedBlockingQueue<PlainSentence> out1 = this.queuePhase1.get(this.outputQueueNum);
                    res = out1.take().toString();
                    break;
                }
                case 2: {
                    LinkedBlockingQueue<SetOfSentences> out2 = this.queuePhase2.get(this.outputQueueNum);
                    res = out2.take().toString();
                    break;
                }
                case 3: {
                    LinkedBlockingQueue<Sentence> out3 = this.queuePhase3.get(this.outputQueueNum);
                    res = out3.take().toString();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return res;
    }

    public <T> LinkedList<T> getResultOfDocument(T a) throws ResultTypeException {
        LinkedList<CommObject> list;
        block11: {
            Class<?> objClass = a.getClass();
            list = new LinkedList<CommObject>();
            try {
                if (PlainSentence.class.equals(objClass)) {
                    PlainSentence ps;
                    if (this.outputPhaseNum != 1) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(this.outputQueueNum);
                    while ((ps = queue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                        list.add(ps);
                        if (!ps.isEndOfDocument()) continue;
                        break block11;
                    }
                    break block11;
                }
                if (SetOfSentences.class.equals(objClass)) {
                    SetOfSentences sos;
                    if (this.outputPhaseNum != 2) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<SetOfSentences> queue = this.queuePhase2.get(this.outputQueueNum);
                    while ((sos = queue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                        list.add(sos);
                        if (!sos.isEndOfDocument()) continue;
                        break block11;
                    }
                    break block11;
                }
                if (Sentence.class.equals(objClass)) {
                    Sentence sent;
                    if (this.outputPhaseNum != 3) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<Sentence> queue = this.queuePhase3.get(this.outputQueueNum);
                    while ((sent = queue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                        list.add(sent);
                        if (!sent.isEndOfDocument()) continue;
                        break block11;
                    }
                    break block11;
                }
                throw new ResultTypeException(this.outputPhaseNum);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public String getResultOfDocument() {
        StringBuffer buf = new StringBuffer();
        try {
            switch (this.outputPhaseNum) {
                case 1: {
                    PlainSentence ps;
                    LinkedBlockingQueue<PlainSentence> out1 = this.queuePhase1.get(this.outputQueueNum);
                    do {
                        ps = out1.take();
                        buf.append(ps);
                        buf.append('\n');
                    } while (!ps.isEndOfDocument());
                    break;
                }
                case 2: {
                    SetOfSentences sos;
                    LinkedBlockingQueue<SetOfSentences> out2 = this.queuePhase2.get(this.outputQueueNum);
                    do {
                        sos = out2.take();
                        buf.append(sos);
                        buf.append('\n');
                    } while (!sos.isEndOfDocument());
                    break;
                }
                case 3: {
                    Sentence sent;
                    LinkedBlockingQueue<Sentence> out3 = this.queuePhase3.get(this.outputQueueNum);
                    do {
                        sent = out3.take();
                        buf.append(sent);
                        buf.append('\n');
                    } while (!sent.isEndOfDocument());
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private void analyzeInSingleThread() {
        if (this.plainTextPluginCnt == 0) {
            return;
        }
        LinkedBlockingQueue<PlainSentence> inQueue1 = null;
        LinkedBlockingQueue<PlainSentence> outQueue1 = null;
        PlainSentence ps = null;
        outQueue1 = this.queuePhase1.get(0);
        int i = 0;
        while (i < this.plainTextPluginCnt) {
            inQueue1 = outQueue1;
            outQueue1 = this.queuePhase1.get(i + 1);
            while ((ps = inQueue1.poll()) != null) {
                if ((ps = this.plainTextProcessors[i].doProcess(ps)) != null) {
                    outQueue1.add(ps);
                }
                while (this.plainTextProcessors[i].hasRemainingData()) {
                    ps = this.plainTextProcessors[i].doProcess(null);
                    if (ps == null) continue;
                    outQueue1.add(ps);
                }
                ps = this.plainTextProcessors[i].flush();
                if (ps == null) continue;
                outQueue1.add(ps);
            }
            ++i;
        }
        if (this.morphAnalyzer == null) {
            return;
        }
        LinkedBlockingQueue<SetOfSentences> inQueue2 = null;
        LinkedBlockingQueue<SetOfSentences> outQueue2 = null;
        SetOfSentences sos = null;
        inQueue1 = outQueue1;
        outQueue2 = this.queuePhase2.get(0);
        while ((ps = inQueue1.poll()) != null) {
            sos = this.morphAnalyzer.morphAnalyze(ps);
            if (sos == null) continue;
            outQueue2.add(sos);
        }
        if (this.morphemePluginCnt == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < this.morphemePluginCnt) {
            inQueue2 = outQueue2;
            outQueue2 = this.queuePhase2.get(i2 + 1);
            while ((sos = inQueue2.poll()) != null) {
                if ((sos = this.morphemeProcessors[i2].doProcess(sos)) == null) continue;
                outQueue2.add(sos);
            }
            ++i2;
        }
        if (this.posTagger == null) {
            return;
        }
        LinkedBlockingQueue<Sentence> inQueue3 = null;
        LinkedBlockingQueue<Sentence> outQueue3 = null;
        Sentence sent = null;
        inQueue2 = outQueue2;
        outQueue3 = this.queuePhase3.get(0);
        while ((sos = inQueue2.poll()) != null) {
            sent = this.posTagger.tagPOS(sos);
            if (sent == null) continue;
            outQueue3.add(sent);
        }
        if (this.posPluginCnt == 0) {
            return;
        }
        int i3 = 0;
        while (i3 < this.posPluginCnt) {
            inQueue3 = outQueue3;
            outQueue3 = this.queuePhase3.get(i3 + 1);
            while ((sent = inQueue3.poll()) != null) {
                if ((sent = this.posProcessors[i3].doProcess(sent)) == null) continue;
                outQueue3.add(sent);
            }
            ++i3;
        }
    }

    public void reloadUserDic(String path) throws IOException {
        this.morphAnalyzer.loadUserDic(path);
        this.userDicFile = path;
    }
}

