% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MD_distant_matrices.R
\name{MD_distant_matrices}
\alias{MD_distant_matrices}
\title{MD Distant Matrices}
\usage{
MD_distant_matrices(p, n = 1, mat_list = list(), bestof = 10)
}
\arguments{
\item{p}{The dimension of the orthogonal matrices.}

\item{n}{The length of the returned matrix list.}

\item{mat_list}{A list of already existing orthogonal matrices.}

\item{bestof}{The number of candidates evaluated for each new matrix.}
}
\value{
A list which contains the already given and the additionally created matrices.
}
\description{
Creates orthogonal matrices in the Stiefel manifold, which are distant to each other
by the MD index and optionally also distant to a given set of matrices.
}
\details{
If a matrix list should be created from scratch, i.e. the parameter
\code{mat_list} was not provided, then the first orthogonal matrix 
of the returned list is randomly generated by \code{ICtest::rorth}.
If \code{n} is larger than one or if a matrix list was provided, 
then for each additional matrix \eqn{M_{k+1}} we consider the distance 
\eqn{\min(\textrm{MD}(M_1, M_{k+1}),\textrm{MD}(M_2, M_{k+1}),\dots, \textrm{MD}(M_k, M_{k+1}))}
to all previous list entries. This distance is evaluated for \code{bestof} 
randomly generated orthogonal candidate matrices from which the
furthest is selected.
}
\examples{
# creates one orthogonal 3x3 matrix (result of ICtest::rorth(3)), wrapped in a list
MD_distant_matrices(3, 1)

# creates a 4x4 matrix, distant to the unit matrix and returns both
MD_distant_matrices(4, 2, mat_list = list(diag(4)))

# creates two orthogonal 3x3 matrices with more candidates to get better distances.
m <- MD_distant_matrices(3, 2, bestof = 20)
JADE::MD(m[[1]], m[[2]])
}
\seealso{
\code{\link[ICtest]{rorth}}
}
\author{
Christoph L. Koesner
}
