\name{dinisurface}

\alias{dinisurface}

\title{Ulisse Dini Data Set Generator}

\description{This function creates a data set based upon data points distributed on a Ulisse Dini's surface.}

\usage{
dinisurface(N=1000)
}

\arguments{
  \item{N}{Number of data points.}
}

\value{
    The function returns a three dimensional data set.
  }

\author{Stefano Cacciatore and Leonardo Tenori}

\references{
Cacciatore S, Luchinat C, Tenori L	\cr
Knowledge discovery by accuracy maximization.\cr
\emph{Proc Natl Acad Sci U S A} 2014;111(14):5117-22. doi: 10.1073/pnas.1220873111. \href{http://www.pnas.org/content/111/14/5117}{Link}
\cr	\cr
Cacciatore S, Tenori L, Luchinat C, Bennett PR, MacIntyre DA	\cr
KODAMA: an updated R package for knowledge discovery and data mining.	\cr
\emph{Bioinformatics} 2016. doi: 10.1093/bioinformatics/btw705. \href{https://academic.oup.com/bioinformatics/article/doi/10.1093/bioinformatics/btw705/2667156/KODAMA-an-R-package-for-knowledge-discovery-and}{Link}
}

\seealso{\code{\link{helicoid}},\code{\link{swissroll}},\code{\link{spirals}}}

\examples{
require("rgl")
x=dinisurface()
open3d()
plot3d(x, col=rainbow(1000),box=FALSE,size=3)
rgl.postscript("dinisurface.pdf", fmt="pdf")
}

\keyword{dataset}
