% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hytek_parse.R
\name{hytek_parse}
\alias{hytek_parse}
\title{Parses Hytek format track and field results inside \code{tf_parse}}
\usage{
hytek_parse(
  hytek_file = file,
  hytek_relay_athletes = relay_athletes,
  hytek_rounds = rounds,
  hytek_round_attempts = round_attempts,
  hytek_split_attempts = split_attempts,
  hytek_splits = splits,
  hytek_split_length = split_length
)
}
\arguments{
\item{hytek_file}{data with row numbers added}

\item{hytek_relay_athletes}{should \code{tf_parse} try to include the names
of relay athletes for relay events?  Names will be listed in new columns
"Relay-Athlete_1", "Relay_Athlete_2" etc.  Defaults to \code{FALSE}.}

\item{hytek_rounds}{should \code{tf_parse} try to include rounds for
jumping/throwing events?  Please note this will add a significant number of
columns to the resulting data frame.  Defaults to \code{FALSE}.}

\item{hytek_round_attempts}{should \code{tf_parse} try to include rounds
results (i.e. "PASS", "X", "O") for high jump and pole value events?
Please note this will add a significant number of columns to the resulting
data frame. Defaults to \code{FALSE}}

\item{hytek_split_attempts}{should \code{tf_parse} split attempts from each
round into separate columns?  For example "XXO" would result in three
columns, one for "X', another for the second "X" and third for "O".  There
will be a lot of columns.  Defaults to \code{FALSE}}

\item{hytek_splits}{either \code{TRUE} or the default, \code{FALSE} - should
\code{hytek_parse} attempt to include splits.}

\item{hytek_split_length}{either the distance at which splits are collected
(must be constant distance) or the default, \code{1}, the length of track
at which splits are recorded.  Not all results are internally consistent on
this issue.  If in doubt use the default \code{1}}
}
\value{
a data frame of track and field results
}
\description{
Outputs a data frame of track and field results
}
\seealso{
\code{hytek_parse} is runs inside
\code{\link{tf_parse}}
}
