% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JuliaConnectoR-package.R
\name{EnvVars-JuliaConnectoR}
\alias{EnvVars-JuliaConnectoR}
\alias{JULIA_BINDIR}
\alias{JULIACONNECTOR_JULIAENV}
\alias{JULIACONNECTOR_SERVER}
\title{Environment variables used by the \pkg{JuliaConnectoR}}
\description{
There are some environment variables which can be used to deviate from the
default behavior of the package.
To have an effect, these environment variables must be set before a Julia
connection is established, i.e., before the first call to Julia or before a
call to  \code{\link{startJuliaServer}}.
All the variables are optional.
}
\details{
The environment variables that are used in the package are listed below:
\describe{
\item{\env{JULIA_BINDIR}:}{The directory where the \code{bin} directory of
  the Julia can be specified explicitly. This allows, e.g., to easily work
  with different Julia versions without having to modify the system
  \env{PATH}.}
\item{\env{JULIACONNECTOR_JULIAENV}:}{Specify environment variables only for
   Julia.
   (This does not work on Windows and the variable is ignored there.)
   This allows, e.g,, to set
   the LD_LIBRARY_PATH variable to a different value for Julia than for R.
   The value can be any R code that defines variables, e.g.,
    \code{"LD_LIBRARY_PATH=''"} is a valid value.}
\item{\env{JULIACONNECTOR_SERVER}:}{Specifies the server address of a
  (running) Julia server that the R process can connect to.
  A possible example value is "localhost:11980", specifying host and port.
  The function \code{\link{startJuliaServer}} sets this variable and
  communicates the location of the server to child processes with it.
  Due to security concerns, the Julia server accepts only connections from
  the same machine and connecting to remote machines is currently not
  possible.}
}
}
