/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Interpreter;

import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.EvaluatorManager;
import org.omegahat.Environment.Interpreter.Options;
import org.omegahat.Environment.Interpreter.Task;
import org.omegahat.Environment.Interpreter.TaskQueue;
import org.omegahat.Environment.Interpreter.UserClassEvaluator;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;

public class TaskQueueEvaluator
extends UserClassEvaluator
implements Runnable {
    protected TaskQueue queue = new TaskQueue();
    protected boolean terminate = false;

    public TaskQueueEvaluator() {
    }

    public TaskQueueEvaluator(Evaluator evaluator) {
        super(evaluator);
    }

    public TaskQueueEvaluator(EvaluatorManager evaluatorManager) {
        super(evaluatorManager);
    }

    public TaskQueueEvaluator(Options options) {
        super(options);
    }

    public Task addTask(Task task) {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.addElement(task);
        }
        this.queue.notifyAll();
        return task;
    }

    public Task addTask(ExpressionInt expressionInt) {
        return this.addTask(new Task(expressionInt));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.terminate()) {
            Task task;
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                while (true) {
                    if (this.queue.size() >= 1) {
                        task = (Task)this.queue.elementAt(0);
                        this.queue.removeElementAt(0);
                        break;
                    }
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                task.evaluate(this);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean terminate() {
        return this.terminate;
    }

    public boolean terminate(boolean bl) {
        this.terminate = bl;
        return this.terminate();
    }
}

