/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptList;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NonnegativeIntegerGenerator;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import com.sun.java.help.search.Schema;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.SearchItem;

class SearchEnvironment {
    private IntegerArray concepts;
    private IntegerArray offsets;
    private byte[] allLists;
    private IntegerArray concepts3;
    private IntegerArray offsets3;
    private byte[] allChildren;
    private IntegerArray documents;
    private IntegerArray offsets2;
    private IntegerArray titles;
    private RAFFile positionsFile = null;
    private byte[] positions;
    private ByteArrayDecompressor compr;
    private BtreeDict tmap;
    private URL base;
    private String indexDir;
    private static boolean debugFlag = false;

    public SearchEnvironment(String string, URL uRL) throws Exception {
        this.base = uRL;
        this.indexDir = string;
        this.readFromDB();
        this.compr = new ByteArrayDecompressor(null, 0);
    }

    public void close() throws IOException {
        this.positionsFile.close();
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("SearchEnvironment: " + string);
        }
    }

    public String fetch(int n) throws Exception {
        return this.tmap.fetch(n);
    }

    public int fetch(String string) throws Exception {
        return this.tmap.fetch(string);
    }

    public NonnegativeIntegerGenerator getChildIterator(int n) {
        int n2 = this.concepts3.indexOf(n);
        if (n2 >= 0) {
            return new ConceptList(this.allChildren, this.offsets3.at(n2));
        }
        return null;
    }

    public void getChildren(int n, IntegerArray integerArray) throws Exception {
        int n2 = this.concepts3.indexOf(n);
        if (n2 >= 0) {
            int n3 = this.offsets3.at(n2);
            this.compr.initReading(this.allChildren, n3 + 1);
            this.compr.ascDecode(this.allChildren[n3], integerArray);
        }
    }

    public int getConceptLength(int n) throws Exception {
        return this.tmap.fetch(n).length();
    }

    public int getDocumentIndex(int n) {
        return this.offsets2.at(n);
    }

    public NonnegativeIntegerGenerator getDocumentIterator(int n) {
        int n2 = this.concepts.indexOf(n);
        if (n2 >= 0) {
            return new ConceptList(this.allLists, this.offsets.at(n2));
        }
        return null;
    }

    public byte[] getPositions(int n) throws IOException {
        int n2 = this.offsets2.at(n);
        int n3 = n + 1 == this.offsets2.cardinality() ? (int)this.positionsFile.length() : this.offsets2.at(n + 1);
        this.positions = new byte[n3 - n2];
        this.positionsFile.seek(n2);
        this.positionsFile.read(this.positions, 0, n3 - n2);
        return this.positions;
    }

    private URL getURL(String string) throws MalformedURLException {
        URL uRL = this.base;
        String string2 = this.indexDir;
        URL uRL2 = null;
        if (uRL == null) {
            File file = new File(string2);
            if (file.exists()) {
                if (File.separatorChar != '/') {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                if (string2.lastIndexOf(47) != string2.length() - 1) {
                    string2 = string2.concat("/");
                }
                SearchEnvironment.debug("file:" + string2);
                uRL2 = new URL("file", "", string2);
            } else {
                uRL2 = new URL(string2);
            }
        }
        URL uRL3 = uRL != null ? new URL(uRL, String.valueOf(string2) + "/" + string) : new URL(uRL2, string);
        return uRL3;
    }

    public String hitToString(QueryHit queryHit) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(queryHit.getScore());
        stringBuffer.append(" ");
        stringBuffer.append(this.fetch(this.documents.at(queryHit.getDocument())));
        stringBuffer.append(" [");
        stringBuffer.append(queryHit.getBegin());
        stringBuffer.append(", ");
        stringBuffer.append(queryHit.getEnd());
        stringBuffer.append("], {");
        int[] nArray = queryHit.getArray();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > 0) {
                stringBuffer.append(this.fetch(nArray[n]));
            } else {
                stringBuffer.append("--");
            }
            if (n < nArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public SearchItem makeItem(QueryHit queryHit) throws Exception {
        Vector<String> vector = new Vector<String>();
        int[] nArray = queryHit.getArray();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > 0) {
                vector.addElement(this.fetch(nArray[n]));
            }
            ++n;
        }
        return new SearchItem(this.base, this.fetch(this.titles.at(queryHit.getDocument())), Locale.getDefault().toString(), this.fetch(this.documents.at(queryHit.getDocument())), queryHit.getScore(), queryHit.getBegin(), queryHit.getEnd(), vector);
    }

    public boolean occursInText(int n) {
        return this.concepts.indexOf(n) >= 0;
    }

    private void readChildrenData() throws Exception {
        try {
            URL uRL = this.getURL("CHILDREN.TAB");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n = bufferedInputStream.read();
            this.concepts3 = new IntegerArray(4096);
            StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
            streamDecompressor.ascDecode(n, this.concepts3);
            int n2 = bufferedInputStream.read();
            this.offsets3 = new IntegerArray(this.concepts3.cardinality() + 1);
            this.offsets3.add(0);
            StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
            streamDecompressor2.ascDecode(n2, this.offsets3);
            bufferedInputStream.close();
            uRL = this.getURL("CHILDREN");
            uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
            int n3 = uRLConnection.getContentLength();
            this.allChildren = new byte[n3];
            bufferedInputStream.read(this.allChildren);
            bufferedInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (IOException iOException) {
            this.concepts3 = new IntegerArray(1);
        }
    }

    private void readFromDB() throws Exception {
        BufferedInputStream bufferedInputStream = null;
        Schema schema = new Schema(this.base, this.indexDir, false);
        BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
        btreeDictParameters.readState();
        this.tmap = new BtreeDict(btreeDictParameters);
        this.readChildrenData();
        URL uRL = this.getURL("DOCS.TAB");
        URLConnection uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        int n = bufferedInputStream.read();
        this.concepts = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n, this.concepts);
        int n2 = bufferedInputStream.read();
        this.offsets = new IntegerArray(this.concepts.cardinality() + 1);
        this.offsets.add(0);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n2, this.offsets);
        bufferedInputStream.close();
        uRL = this.getURL("DOCS");
        uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        int n3 = 0;
        while ((n3 = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        this.allLists = byteArrayOutputStream.toByteArray();
        bufferedInputStream.close();
        uRL = this.getURL("OFFSETS");
        uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        n = bufferedInputStream.read();
        this.documents = new IntegerArray(4096);
        streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n, this.documents);
        n2 = bufferedInputStream.read();
        this.offsets2 = new IntegerArray(this.documents.cardinality() + 1);
        streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n2, this.offsets2);
        int n4 = bufferedInputStream.read();
        this.titles = new IntegerArray(this.documents.cardinality());
        StreamDecompressor streamDecompressor3 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor3.decode(n4, this.titles);
        bufferedInputStream.close();
        RAFFileFactory rAFFileFactory = RAFFileFactory.create();
        uRL = this.getURL("POSITIONS");
        this.positionsFile = rAFFileFactory.get(uRL, false);
    }
}

