/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Databases;

import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.Databases.AttachedDatabase;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.DatabaseAssignListener;
import org.omegahat.Environment.Databases.DatabaseAttachEvent;
import org.omegahat.Environment.Databases.DatabaseNotifier;
import org.omegahat.Environment.Databases.SearchPathEvent;
import org.omegahat.Environment.Databases.SearchPathListener;
import org.omegahat.Environment.Utils.OrderedTable;

public class SearchPath
extends OrderedTable {
    protected Vector pathListeners;

    public SearchPath() {
    }

    public SearchPath(int n) {
        super(n);
    }

    public SearchPath(Vector vector2) {
        super(vector2.size());
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.attach((Database)enumeration.nextElement());
        }
    }

    public SearchPath(Database database) {
        super(5);
        this.attach(database);
    }

    public SearchPath(SearchPath searchPath) {
        super(searchPath);
    }

    public int addAssignListener(DatabaseAssignListener databaseAssignListener) {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof DatabaseNotifier)) continue;
            ((DatabaseNotifier)v).addAssignListener(databaseAssignListener);
            ++n;
        }
        return n;
    }

    public int addPathListener(SearchPathListener searchPathListener) {
        if (this.pathListeners() == null) {
            this.pathListeners(new Vector(2));
        }
        this.pathListeners().addElement(searchPathListener);
        return this.pathListeners().size();
    }

    public boolean assign(String string, Object object) throws Exception {
        Database database = (Database)this.ordered().elementAt(0);
        database.assign(string, object);
        return true;
    }

    public AttachedDatabase attach(Database database) {
        return this.attach(database, -1);
    }

    public AttachedDatabase attach(Database database, int n) {
        return this.attach(database, database.getName(), n);
    }

    public AttachedDatabase attach(Database database, String string) {
        return this.attach(database, string, -1);
    }

    public AttachedDatabase attach(Database database, String string, int n) {
        if (n < 0 || n >= this.size()) {
            super.put(string, database);
            n = this.size() - 1;
        } else {
            this.put(string, database, false);
            this.ordered().insertElementAt(database, n);
            this.orderedKeys().insertElementAt(string, n);
        }
        this.notifyListeners(new DatabaseAttachEvent(database, this));
        return new AttachedDatabase(database, n, this);
    }

    public int detach(int n) {
        if (n < 0 || n >= this.size()) {
            return -1;
        }
        return this.detach((Database)this.elementAt(n));
    }

    public int detach(Database database) {
        this.removeElement(database);
        return this.size();
    }

    public Object elementAt(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return (Database)this.ordered().elementAt(n);
    }

    public boolean exists(String string) {
        Enumeration enumeration = this.ordered().elements();
        while (enumeration.hasMoreElements()) {
            Database database = (Database)enumeration.nextElement();
            if (!database.exists(string)) continue;
            return true;
        }
        return false;
    }

    public Database[] find(String string, boolean bl) {
        Database[] databaseArray = new Database[bl ? 1 : this.size()];
        int n = 0;
        Enumeration enumeration = this.ordered().elements();
        while (enumeration.hasMoreElements()) {
            Database database = (Database)enumeration.nextElement();
            if (!database.exists(string)) continue;
            databaseArray[n++] = database;
            if (!bl) continue;
            return databaseArray;
        }
        if (n == 0) {
            databaseArray = null;
        }
        return databaseArray;
    }

    public Object get(String string) {
        Object object = super.get(string);
        if (object != null) {
            return object;
        }
        Database[] databaseArray = this.find(string, false);
        if (databaseArray != null && databaseArray.length > 0) {
            return databaseArray[0].get(string);
        }
        return null;
    }

    public Database getDatabase(String string) {
        return (Database)super.get(string);
    }

    public void notifyListeners(SearchPathEvent searchPathEvent) {
        if (this.pathListeners() == null) {
            return;
        }
        Enumeration enumeration = this.pathListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SearchPathListener)enumeration.nextElement()).searchPathAction(searchPathEvent);
        }
    }

    public String[] objects() {
        String[][] stringArray = new String[3][];
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.ordered().elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((Database)enumeration.nextElement()).objects();
            n2 += stringArray[n] == null ? 0 : stringArray[n].length;
            ++n;
        }
        String[] stringArray2 = new String[n2];
        n2 = 0;
        n = 0;
        while (n < stringArray.length) {
            System.arraycopy(stringArray[n], 0, stringArray2, n2, stringArray[n].length);
            n2 += stringArray[n].length;
            ++n;
        }
        return stringArray2;
    }

    public Vector pathListeners() {
        return this.pathListeners;
    }

    public Vector pathListeners(Vector vector2) {
        this.pathListeners = vector2;
        return this.pathListeners();
    }

    public Object remove(String string) {
        Database[] databaseArray = this.find(string, false);
        if (databaseArray != null && databaseArray.length > 0) {
            return databaseArray[0].remove(string);
        }
        return null;
    }

    public void removePathListener(SearchPathListener searchPathListener) {
        if (this.listeners() == null) {
            return;
        }
        this.listeners().removeElement(searchPathListener);
    }
}

