% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/JacobiR.R
\name{JacobiR}
\alias{JacobiR}
\title{The Jacobi Algorithm in Pure R}
\usage{
JacobiR(x, only_values = FALSE, eps = if (!only_values) .Machine$double.eps
  else sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{a real symmetric matrix}

\item{only_values}{A logical value: Do you want eigenvalues only?}

\item{eps}{an error tolerance}
}
\description{
The Jacobi Algorithm
}
\details{
Eigenvalues and optionally, eigenvectore of a real symmetric matrix using the
classical Jacobi algorithm, (Jacobi, 1854)
}
\examples{
(V <- crossprod(matrix(1:25, 5)))
JacobiR(V)
}

