
#'
#' PCR_Train
#' 
#' PCR_Train is the train set of the PCR model. It consists of Age, 
#' MeanDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MeanDNE.Convex 
#' and Proportion.DNEunder0.0001. The number of rows is 702.
#' 
#' 
#' @export
#' 
PCR_Train<-{
  Age <- c(21, 21, 71, 71, 72, 72, 78, 78, 87, 72, 71, 71, 80, 79, 79, 77, 77, 56, 56, 68, 68, 70, 70, 67, 67, 73, 73, 75, 33, 48, 78, 76, 76, 93, 93, 60, 75, 75, 79, 86, 70, 79, 68, 68, 68, 68, 46, 46, 68, 68, 80, 52, 52, 76, 49, 49, 20, 20, 35, 35, 60, 39, 39, 69, 68, 32, 77, 77, 80, 80, 45, 75, 75, 73, 73, 48, 48, 86, 85, 57, 57, 51, 51, 93, 93, 76, 76, 72, 62, 51, 51, 69, 65, 68, 68, 89, 75, 47, 68, 54, 77, 77, 39, 39, 47, 25, 28, 28, 56, 56, 34, 34, 61, 55, 33, 33, 23, 23, 47, 38, 38, 26, 26, 29, 20, 20, 79, 66, 89, 89, 72, 22, 25, 25, 86, 94, 94, 42, 20, 69, 32, 26, 69, 69, 67, 67, 34, 70, 70, 33, 33, 87, 87, 25, 25, 63, 45, 35, 79, 20, 67, 20, 35, 35, 22, 22, 76, 76, 25, 23, 23, 26, 26, 45, 45, 28, 46, 46, 46, 46, 20, 20, 41, 41, 37, 37, 48, 48, 27, 27, 75, 72, 62, 62, 46, 65, 23, 23, 44, 44, 72, 72, 80, 65, 75, 85, 49, 49, 55, 64, 40, 59, 59, 64, 70, 45, 45, 52, 52, 20, 20, 72, 69, 61, 61, 76, 43, 43, 60, 28, 60, 28, 35, 58, 62, 58, 47, 47, 79, 52, 52, 73, 73, 52, 52, 40, 74, 66, 50, 50, 29, 29, 57, 50, 82, 42, 57, 57, 60, 60, 70, 66, 70, 78, 59, 59, 69, 69, 50, 50, 84, 84, 56, 65, 65, 77, 77, 70, 75, 70, 27, 27, 53, 53, 83, 54, 83, 83, 83, 61, 61, 68, 68, 60, 60, 68, 63, 52, 75, 75, 65, 65, 
           69, 71, 71, 80, 31, 80, 31, 60, 20, 20, 41, 78, 69, 43, 43, 30, 30, 54, 54, 75, 44, 75, 44, 57, 58, 69, 69, 75, 75, 52, 52, 29, 29, 63, 63, 57, 57, 83, 35, 35, 65, 65, 38, 38, 53, 53, 39, 51, 51, 65, 67, 67, 62, 27, 27, 65, 27, 68, 65, 65, 54, 54, 33, 33, 72, 31, 31, 69, 69, 72, 72, 52, 52, 54, 51, 51, 70, 59, 59, 65, 65, 54, 51, 84, 84, 56, 56, 74, 74, 50, 50, 68, 54, 59, 59, 43, 32, 50, 50, 67, 67, 75, 49, 63, 63, 61, 61, 31, 89, 56, 56, 56, 46, 34, 34, 57, 62, 62, 33, 33, 68, 68, 52, 52, 53, 39, 63, 38, 50, 62, 68, 68, 66, 66, 59, 52, 48, 48, 47, 47, 70, 25, 70, 25, 68, 55, 55, 28, 28, 31, 31, 54, 54, 53, 57, 57, 35, 35, 51, 51, 26, 39, 39, 71, 71, 44, 25, 25, 45, 45, 23, 28, 28, 32, 32, 30, 30, 49, 64, 64, 62, 62, 49, 35, 70, 30, 30, 29, 46, 38, 38, 71, 71, 48, 48, 25, 25, 67, 67, 68, 64, 64, 60, 60, 45, 39, 49, 44, 26, 34, 34, 65, 68, 80, 80, 60, 48, 64, 48, 43, 65, 37, 37, 63, 63, 89, 83, 83, 43, 90, 90, 67, 94, 94, 81, 24, 92, 92, 21, 43, 30, 30, 49, 76, 32, 32, 68, 38, 38, 37, 
           37, 33, 74, 86, 86, 68, 68, 83, 83, 30, 96, 47, 95, 39, 39, 75, 75, 96, 96, 49, 81, 81, 83, 88, 88, 74, 74, 30, 49, 52, 61, 78, 78, 85, 85, 77, 77, 60, 60, 42, 42, 76, 85, 85, 79, 45, 45, 81, 74, 74, 89, 44, 96, 96, 79, 85, 85, 68, 68, 62, 36, 92, 92, 68, 83, 83, 62, 62, 88, 80, 47, 47, 67, 72, 60, 83, 60, 79, 79, 69, 69, 85, 85, 60, 60, 78, 51, 51, 63, 82, 82, 81, 81, 67, 67, 85, 39, 39, 80, 55, 55, 66, 66, 96, 61, 85, 85, 50, 48, 48, 61, 61, 85, 85, 85, 61, 74, 88, 88, 75, 75, 76, 82, 82, 66, 66, 70, 68, 68, 88, 88, 88, 44, 44, 79, 58, 58, 93, 93, 87, 87, 65, 49, 76, 76, 55, 55, 55, 83, 83)
  
  MeanDNE.Apex <- c(0.026252, 0.029771, 0.037500, 0.036605, 0.039641, 0.033187, 0.039875, 0.036556, 0.038596, 0.030157, 0.043363, 0.037548, 0.040167, 0.036915, 0.044159, 0.042857, 0.026329, 0.033512, 0.034419, 0.042875, 0.038635, 0.041455, 0.037373, 0.048303, 0.036122, 0.039402, 0.034611, 0.036226, 0.028308, 0.030865, 0.037293, 0.037618, 0.036599, 0.040052, 0.039781, 0.028459, 0.045117, 0.034535, 0.038681, 0.041587, 0.043667, 0.040513, 0.033705, 0.041119, 0.043076, 0.043181, 0.031265, 0.032797, 0.033860, 0.034865, 0.036645, 0.037685, 0.027353, 0.034756, 0.027067, 0.030197, 0.029207, 0.025030, 0.032765, 0.031610, 0.030580, 0.027261, 0.025692, 0.036813, 0.037042, 0.028965, 0.038272, 0.036163, 0.033328, 0.039968, 0.025552, 0.037867, 0.035316, 0.040341, 0.042902, 0.037145, 0.036839, 0.046001, 0.039771, 0.033859, 0.027534, 0.029470, 0.034135, 0.049248, 0.040434, 0.044713, 0.038338, 0.037826, 0.037217, 0.033341, 0.031366, 0.030387, 0.034901, 0.036251, 0.035835, 0.048558, 0.032198, 0.034744, 0.042720, 0.034267, 0.042251, 0.036012, 0.035826, 0.026972, 0.031604, 0.023636, 0.023185, 0.028862, 0.033071, 0.040110, 0.032443, 0.034857, 0.033771, 0.031168, 0.038296, 0.032553, 0.035445, 0.027494, 0.026558, 0.030897, 0.035365, 0.024281, 0.023683, 0.031685, 0.027524, 0.022206, 0.038136, 0.037741, 0.039293, 0.040294, 0.029836, 0.028935, 
                    0.020166, 0.027855, 0.039693, 0.047235, 0.048044, 0.033375, 0.029837, 0.030431, 0.033609, 0.030917, 0.038655, 0.040210, 0.039131, 0.035849, 0.027690, 0.040131, 0.040704, 0.026102, 0.027938, 0.042649, 0.040018, 0.032622, 0.030900, 0.038671, 0.030966, 0.028897, 0.045101, 0.025058, 0.032204, 0.024491, 0.032037, 0.032519, 0.026281, 0.023612, 0.047362, 0.036589, 0.023893, 0.030758, 0.032572, 0.023789, 0.037636, 0.036372, 0.037386, 0.026274, 0.036103, 0.030258, 0.031288, 0.031462, 0.032122, 0.026077, 0.027282, 0.024191, 0.035541, 0.030039, 0.029419, 0.032473, 0.025483, 0.031911, 0.040552, 0.038136, 0.040049, 0.034451, 0.037183, 0.041740, 0.031714, 0.026987, 0.029933, 0.026662, 0.034797, 0.041185, 0.041252, 0.036428, 0.035762, 0.039853, 0.032541, 0.031803, 0.033169, 0.034372, 0.027410, 0.039875, 0.039987, 0.030663, 0.032045, 0.029582, 0.025469, 0.038985, 0.027303, 0.025239, 0.025520, 0.038712, 0.032714, 0.041877, 0.037843, 0.032322, 0.027557, 0.030964, 0.042304, 0.033506, 0.033303, 0.031679, 0.025998, 0.037428, 0.033681, 0.029428, 0.033633, 0.033624, 0.034773, 0.033953, 0.031467, 0.039991, 0.040149, 0.031296, 0.030683, 0.029082, 0.044775, 0.033904, 0.037080, 0.038957, 0.032373, 0.032642, 0.034006, 0.030769, 0.040169, 0.033960, 0.036657, 0.030727, 0.032861, 0.030692, 0.038114, 0.035489, 0.037455, 0.036101, 0.027799, 0.033488, 0.029659, 0.036178, 0.035772, 0.032792, 0.037595, 0.036548, 0.030517, 0.030260, 0.034652, 0.034925, 0.052511, 0.041971, 0.036526, 0.039604, 0.026528, 0.024094, 0.030491, 0.035810, 0.035453, 0.032404, 0.034457, 0.040163, 0.040587, 0.035655, 0.035693, 0.040303, 0.039409, 0.028178, 0.032633, 0.032229, 0.039901, 0.037341, 0.039104, 0.034621, 0.039901, 0.035788, 0.038823, 0.034514, 0.044014, 0.035346, 0.031190, 0.039910, 0.029960, 0.035603, 0.025430, 0.030452, 0.030934, 0.036627, 0.037292, 0.039369, 0.031921, 0.031450, 0.025148, 0.037449, 0.037678, 0.039048, 0.036373, 0.034990, 0.030998, 0.035714, 0.028372, 0.034271, 0.030377, 0.040332, 0.037301, 0.027799, 0.032884, 0.036168, 0.024885, 0.036622, 0.037745, 0.031321, 0.034290, 0.036086, 0.026843, 0.028554, 0.026415, 0.032911, 0.032292, 0.036010, 0.030936, 0.030239, 0.035889, 0.037703, 0.033619, 0.033017, 0.031837, 0.041237, 0.037160, 0.031279, 0.024990, 0.040095, 0.024147, 0.034486, 0.036318, 0.032117, 0.031934, 0.028348, 0.027837, 0.028892, 0.033590, 0.028867, 0.024474, 0.037310, 0.034014, 0.042739, 0.035686, 0.029662, 0.035795, 0.028417, 0.034033, 0.031376, 0.039419, 0.035210, 0.032531, 0.033295, 0.040503, 0.030581, 0.036409, 0.046057, 0.032051, 0.035938, 0.033663, 0.033313, 0.030557, 0.026772, 0.034346, 0.029770, 0.036165, 
                    0.033023, 0.035165, 0.032630, 0.030291, 0.032557, 0.034257, 0.031361, 0.035356, 0.030689, 0.033995, 0.041075, 0.039680, 0.036065, 0.034895, 0.027001, 0.042148, 0.035682, 0.032873, 0.034369, 0.027001, 0.026086, 0.027098, 0.027548, 0.032668, 0.028955, 0.029083, 0.029867, 0.037057, 0.032148, 0.028971, 0.033373, 0.028585, 0.027014, 0.032824, 0.030120, 0.029597, 0.038804, 0.034572, 0.030727, 0.034632, 0.038422, 0.031631, 0.034182, 0.028942, 0.031995, 0.031634, 0.030715, 0.037811, 0.028102, 0.032873, 0.023709, 0.037172, 0.034748, 0.032418, 0.029458, 0.026863, 0.028725, 0.026001, 0.027860, 0.035114, 0.026916, 0.036739, 0.031246, 0.029918, 0.028180, 0.031173, 0.032883, 0.029700, 0.032089, 0.030446, 0.032644, 0.033050, 0.031894, 0.040234, 0.032928, 0.033018, 0.027989, 0.025887, 0.029748, 0.026037, 0.033003, 0.031608, 0.031978, 0.026694, 0.036911, 0.041933, 0.038028, 0.035823, 0.031245, 0.038384, 0.029156, 0.035921, 0.029884, 0.030359, 0.032567, 0.034800, 0.031540, 0.034134, 0.037540, 0.041991, 0.033914, 0.031701, 0.024603, 0.029964, 0.034582, 0.029259, 0.034164, 0.035026, 0.037522, 0.039318, 0.033446, 0.031230, 0.029665, 0.030109, 0.036881, 0.023200, 0.033502, 0.034185, 0.032711, 0.037029, 0.037911, 0.040013, 0.037992, 0.036382, 0.029660, 0.028582, 0.026143, 0.036066, 0.031522, 0.026031, 0.031707, 0.035978, 0.047798, 0.040829, 0.039435, 0.031928, 0.051794, 0.032669, 0.034320, 0.045232, 0.043656, 0.032132, 0.026203, 0.047955, 0.047766, 0.022237, 0.033040, 0.025793, 0.025122, 0.031559, 0.038353, 0.031530, 0.031530, 0.031969, 0.025781, 0.026930, 0.029095, 0.026887, 0.029691, 0.039690, 0.040800, 0.037693, 0.038413, 0.035623, 0.042810, 0.033255, 0.032098, 0.062042, 0.027960, 0.045832, 0.035712, 0.029360, 0.044737, 0.040157, 0.038122, 0.044811, 0.037544, 0.031701, 0.042318, 0.043157, 0.037244, 0.044799, 0.036302, 0.038958, 0.032236, 0.034323, 0.039012, 0.040379, 0.037924, 0.036937, 0.031852, 0.035093, 0.040154, 0.033745, 0.035765, 0.024141, 0.037185, 0.031108, 0.041570, 0.044536, 0.033112, 0.030913, 0.034657, 0.030558, 0.039947, 0.039436, 0.039282, 0.053978, 0.036780, 0.049990, 0.044861, 0.037285, 0.037486, 0.038434, 0.041167, 0.037008, 0.035106, 0.035623, 0.039590, 0.036466, 0.030149, 0.041731, 0.036758, 
                    0.032327, 0.028984, 0.035383, 0.042604, 0.032728, 0.029514, 0.024307, 0.039972, 0.036632, 0.041176, 0.036962, 0.039036, 0.043504, 0.036411, 0.036402, 0.039362, 0.045061, 0.028503, 0.036899, 0.039563, 0.037186, 0.026881, 0.038035, 0.036783, 0.047025, 0.044721, 0.041588, 0.042449, 0.035886, 0.035170, 0.029630, 0.033147, 0.036742, 0.032180, 0.030701, 0.030504, 0.036479, 0.040876, 0.036033, 0.049909, 0.039543, 0.029978, 0.034437, 0.035203, 0.037771, 0.032967, 0.046398, 0.057150, 0.043858, 0.038295, 0.038590, 0.046040, 0.040901, 0.035161, 0.037959, 0.035913, 0.041409, 0.036657, 0.032937, 0.030316, 0.038355, 0.042849, 0.041173, 0.043943, 0.039686, 0.043082, 0.036509, 0.027285, 0.049667, 0.031973, 0.029564, 0.036164, 0.034887, 0.041793, 0.045553, 0.036300, 0.032289, 0.041051, 0.037271, 0.034228, 0.030283, 0.031607, 0.038832, 0.035317)
  
  IQRDNE.Apex <- c(0.020457, 0.021202, 0.033377, 0.024387, 0.032199, 0.025132, 0.034967, 0.028333, 0.031930, 0.026965, 0.032644, 0.032692, 0.031643, 0.027145, 0.034841, 0.036300, 0.023363, 0.027485, 0.029874, 0.032944, 0.030657, 0.026766, 0.030010, 0.024001, 0.032272, 0.031312, 0.030542, 0.029708, 0.025183, 0.025921, 0.030212, 0.035227, 0.028924, 0.035432, 0.046517, 0.030744, 0.027405, 0.030950, 0.031633, 0.041813, 0.026166, 0.035220, 0.027442, 0.031182, 0.030753, 0.033668, 0.026565, 0.018179, 0.023655, 0.027983, 0.029282, 0.028995, 0.023012, 0.028466, 0.023259, 0.025646, 0.020527, 0.016183, 0.024343, 0.025121, 0.024575, 0.019947, 0.029267, 0.031601, 0.032622, 0.020257, 0.036735, 0.030927, 0.033296, 0.033004, 0.022284, 0.036189, 0.026365, 0.026591, 0.032936, 0.025476, 0.028523, 0.033015, 0.041202, 0.023222, 0.029562, 0.023494, 0.030524, 0.040456, 0.031356, 0.039536, 0.034144, 0.026939, 0.022410, 0.027224, 0.026593, 0.025320, 0.024868, 0.032920, 0.027327, 0.034077, 0.026726, 0.020512, 0.030905, 0.030071, 0.034047, 0.030138, 0.027781, 0.022093, 0.020357, 0.017985, 0.023342, 0.021402, 0.028314, 0.024727, 0.022349, 0.022697, 
                   0.028459, 0.022894, 0.022388, 0.022677, 0.018172, 0.019869, 0.023217, 0.018523, 0.023897, 0.014872, 0.019195, 0.024815, 0.019235, 0.017931, 0.034757, 0.032200, 0.032662, 0.032662, 0.024310, 0.021083, 0.023474, 0.023205, 0.037855, 0.047903, 0.039862, 0.027692, 0.035185, 0.031854, 0.020670, 0.016524, 0.032976, 0.029701, 0.029560, 0.029986, 0.021998, 0.030196, 0.031796, 0.023223, 0.019893, 0.034942, 0.034951, 0.018583, 0.019127, 0.031837, 0.025498, 0.022648, 0.028397, 0.019958, 0.030971, 0.018076, 0.022976, 0.026821, 0.025037, 0.023062, 0.032109, 0.030176, 0.020360, 0.022063, 0.018122, 0.023503, 0.030227, 0.028271, 0.019892, 0.018005, 0.026202, 0.026732, 0.025325, 0.027010, 0.019240, 0.019364, 0.027487, 0.023685, 0.023811, 0.026568, 0.021216, 0.024506, 0.018258, 0.018780, 0.035556, 0.029473, 0.031254, 0.025138, 0.025458, 0.027174, 0.016061, 0.020144, 0.029141, 0.022677, 0.030755, 0.031887, 0.033431, 0.027145, 0.032781, 0.033153, 0.031604, 0.024278, 0.023892, 0.028510, 0.030700, 0.028258, 0.029858, 0.027323, 0.025050, 0.023271, 0.027785, 0.023192, 0.021166, 0.025268, 0.019381, 0.030318, 0.028053, 0.023667, 0.032462, 0.025577, 0.021547, 0.025916, 0.031998, 0.016790, 0.026778, 0.025093, 0.024232, 0.027687, 0.023651, 0.023000, 0.029355, 0.029472, 0.029736, 0.027023, 0.029103, 0.034843, 0.033009, 0.024191, 0.021008, 0.014298, 0.035563, 0.025495, 0.024792, 0.022230, 0.017368, 0.018404, 0.026613, 0.028670, 0.034339, 0.028108, 0.028670, 0.030104, 0.024599, 0.026013, 0.029111, 0.029012, 0.025232, 0.030422, 0.022956, 0.026979, 0.025295, 0.023563, 0.021123, 0.027195, 0.029827, 0.029136, 0.025084, 0.029845, 0.018389, 0.031540, 0.035467, 0.031916, 0.029598, 0.031368, 0.018025, 0.018634, 0.026713, 0.018648, 0.030535, 0.029267, 0.029592, 0.042988, 0.037561, 0.029892, 0.023433, 0.032377, 0.026586, 0.025717, 0.031463, 0.027274, 0.024010, 0.017056, 0.025946, 0.027219, 0.034010, 0.025441, 0.031389, 0.027859, 0.033902, 0.031691, 0.022380, 0.029857, 0.023995, 0.028120, 0.023012, 0.017463, 0.025755, 0.030858, 0.032910, 0.024801, 0.023160, 0.024278, 0.022540, 0.030451, 0.026347, 0.030660, 0.027739, 0.029331, 0.027740, 0.030749, 0.026980, 0.028839, 0.026411, 0.027260, 0.032989, 0.022123, 0.026011, 0.014642, 0.018241, 0.030683, 0.020292, 0.024715, 0.019242, 0.027083, 0.020720, 0.029415, 0.026458, 0.026389, 0.023788, 0.020789, 0.026806, 0.025264, 0.023441, 0.026236, 0.021444, 0.025034, 0.028658, 0.026783, 0.022847, 0.024242, 0.019112, 0.024653, 0.021720, 0.029094, 0.023627, 0.026099, 0.028234, 0.022495, 0.021763, 0.026041, 0.030118, 0.026311, 0.020031, 0.030368, 0.026444, 0.031965, 0.032689, 0.026179, 0.023535, 
                   0.028440, 0.029309, 0.021452, 0.024717, 0.016804, 0.033205, 0.027246, 0.034090, 0.023919, 0.026389, 0.035973, 0.027814, 0.029639, 0.025731, 0.031107, 0.024309, 0.028225, 0.027613, 0.023494, 0.021171, 0.025973, 0.030207, 0.022414, 0.025828, 0.026023, 0.025660, 0.026916, 0.030293, 0.024104, 0.029818, 0.031839, 0.030424, 0.026073, 0.027784, 0.020022, 0.029092, 0.030097, 0.033990, 0.022964, 0.020022, 0.019768, 0.023947, 0.027707, 0.027743, 0.022860, 0.022788, 0.024064, 0.029503, 0.029092, 0.024267, 0.028693, 0.023559, 0.022699, 0.029521, 0.024006, 0.027091, 0.030141, 0.029587, 0.026578, 0.031143, 0.030134, 0.021724, 0.026914, 0.026215, 0.026862, 0.025712, 0.024351, 0.028541, 0.024120, 0.022187, 0.022401, 0.033562, 0.030453, 0.026117, 0.021165, 0.021597, 0.024021, 0.020300, 0.026125, 0.022929, 0.020880, 0.027698, 0.026617, 0.025131, 0.026365, 0.026382, 0.024973, 0.017180, 0.021377, 0.021973, 0.026085, 0.026315, 0.024329, 0.018176, 0.018422, 0.028737, 0.023894, 0.018518, 0.021830, 0.022955, 0.025965, 0.022857, 0.018623, 0.023674, 0.028954, 0.030478, 0.029744, 0.029980, 0.024861, 0.023691, 0.026464, 0.031733, 0.027435, 0.023589, 0.018394, 0.022984, 0.025078, 0.021274, 0.030211, 0.034314, 0.028505, 0.025978, 0.027064, 0.018757, 0.031278, 0.032368, 0.027682, 0.026935, 0.024507, 0.028353, 0.030174, 0.028032, 0.025811, 0.020318, 0.022370, 0.019276, 0.029725, 0.025011, 0.030369, 0.031277, 0.022802, 0.030045, 0.023621, 0.025307, 0.022020, 0.022429, 0.022534, 0.028496, 0.025032, 0.021428, 0.028992, 0.026755, 0.035252, 0.036643, 0.028777, 0.019536, 0.034315, 0.026914, 0.029446, 0.037025, 0.035909, 0.028809, 0.021273, 0.039786, 0.031208, 0.023828, 0.027486, 0.022599, 0.029197, 0.017653, 0.033500, 0.024194, 0.024194, 0.026890, 0.019622, 0.021314, 0.024225, 0.020838, 0.021187, 0.033545, 0.027667, 0.032790, 0.030901, 0.029426, 0.035628, 0.036976, 0.025546, 0.055134, 0.022125, 0.035826, 0.026528, 0.026348, 0.030556, 0.034297, 0.028168, 0.033435, 0.029481, 0.032967, 0.029468, 0.033891, 0.033334, 0.032642, 0.030465, 0.030134, 0.021596, 0.021728, 0.023602, 0.026317, 0.031505, 0.031624, 0.029211, 0.020597, 0.032402, 0.020257, 0.029248, 0.029826, 0.026687, 0.016634, 0.035802, 0.035204, 0.036445, 0.027313, 0.028309, 
                   0.031280, 0.033955, 0.034783, 0.029968, 0.048520, 0.027998, 0.031759, 0.039103, 0.035732, 0.027125, 0.034934, 0.037466, 0.031311, 0.027343, 0.019271, 0.031660, 0.030090, 0.024252, 0.033963, 0.027432, 0.032501, 0.030355, 0.024388, 0.030064, 0.023713, 0.022818, 0.028660, 0.034046, 0.027587, 0.028953, 0.022038, 0.035331, 0.028839, 0.029654, 0.030590, 0.028940, 0.034790, 0.025990, 0.023331, 0.027516, 0.020899, 0.023108, 0.025659, 0.036724, 0.036294, 0.037820, 0.032512, 0.026893, 0.030773, 0.029571, 0.022741, 0.021162, 0.032645, 0.030949, 0.026654, 0.024856, 0.027738, 0.033360, 0.030876, 0.038088, 0.036105, 0.024707, 0.029268, 0.021784, 0.023505, 0.027884, 0.034949, 0.027574, 0.036595, 0.024410, 0.032515, 0.029637, 0.034275, 0.032462, 0.025515, 0.036010, 0.032820, 0.027980, 0.029126, 0.027426, 0.029955, 0.029969, 0.033214, 0.035328, 0.032427, 0.039703, 0.026413, 0.017845, 0.042601, 0.022564, 0.024589, 0.030207, 0.026974, 0.036711, 0.031446, 0.028675, 0.026206, 0.029474, 0.031627, 0.029811, 0.024534, 0.024230, 0.031803, 0.030903)
  
  TotalDNE.TotalPolygonFaces <- c(0.020791, 0.036184, 0.025182, 0.022533, 0.028801, 0.029517, 0.024517, 0.026235, 0.025195, 0.028578, 0.026717, 0.023180, 0.023626, 0.027568, 0.022099, 0.034417, 0.038190, 0.019484, 0.022448, 0.023540, 0.021462, 0.028718, 0.024106, 0.021462, 0.024587, 0.023750, 0.028202, 0.027648, 0.020585, 0.016475, 0.031587, 0.028127, 0.022577, 0.027798, 0.027348, 0.027085, 0.030688, 0.028520, 0.026925, 0.029828, 0.027370, 0.029350, 0.021948, 0.027318, 0.020853, 0.020546, 0.017495, 0.022849, 0.020716, 0.024999, 0.027665, 0.019395, 0.014926, 0.028915, 0.018255, 0.017240, 0.018490, 0.020226, 0.015563, 0.015824, 0.027095, 0.014684, 0.015986, 0.028484, 0.024825, 0.014458, 0.025392, 0.032416, 0.031221, 0.030067, 0.021180, 0.022241, 0.027213, 0.025209, 0.030258, 0.018840, 0.015882, 0.033949, 0.026184, 0.023979, 0.024064, 0.022986, 0.020092, 0.035271, 0.032218, 0.022283, 0.022428, 0.028285, 0.019812, 0.019829, 
                                  0.019990, 0.025257, 0.028381, 0.020687, 0.026424, 0.040472, 0.019487, 0.018898, 0.023810, 0.017159, 0.025464, 0.032571, 0.016603, 0.015340, 0.015058, 0.018624, 0.014517, 0.019894, 0.023768, 0.027023, 0.015115, 0.015473, 0.022980, 0.025873, 0.015943, 0.017775, 0.016683, 0.016368, 0.024074, 0.018157, 0.019255, 0.011815, 0.014029, 0.013565, 0.017607, 0.014031, 0.023770, 0.026150, 0.029464, 0.032408, 0.027608, 0.016780, 0.014916, 0.017781, 0.031173, 0.051624, 0.037345, 0.016533, 0.013356, 0.027235, 0.014008, 0.014965, 0.020696, 0.029043, 0.028615, 0.028943, 0.017215, 0.026839, 0.025247, 0.017628, 0.016171, 0.027052, 0.030905, 0.014963, 0.013356, 0.021180, 0.020030, 0.016122, 0.024294, 0.018852, 0.024627, 0.019189, 0.014476, 0.013903, 0.016818, 0.021075, 0.027865, 0.017271, 0.015801, 0.016741, 0.022113, 0.018924, 0.027470, 0.021693, 0.020322, 0.018785, 0.017329, 0.021162, 0.016343, 0.017383, 0.014993, 0.015903, 0.019934, 0.016081, 0.019682, 0.014298, 0.024160, 0.023261, 0.014013, 0.015189, 0.022082, 0.022754, 0.028433, 0.021544, 0.021574, 0.020698, 0.012892, 0.016994, 0.016089, 0.023084, 0.031309, 0.027879, 0.023067, 0.029585, 0.033288, 0.032653, 0.018004, 0.024504, 0.022935, 0.022439, 0.018371, 0.024346, 0.023927, 0.026475, 0.030102, 0.023152, 0.015555, 0.022232, 0.019016, 0.016432, 0.018233, 0.023740, 0.027779, 0.025376, 0.020991, 0.027105, 0.015816, 0.023941, 0.030465, 0.023662, 0.023764, 0.023377, 0.022095, 0.028835, 0.027389, 0.026951, 0.017910, 0.024942, 0.034824, 0.018336, 0.023955, 0.022038, 0.035476, 0.018810, 0.023971, 0.016858, 0.028436, 0.023600, 0.021151, 0.021641, 0.016147, 0.015161, 0.027347, 0.025851, 0.030713, 0.016967, 0.023420, 0.027809, 0.030292, 0.021407, 0.029519, 0.021179, 0.027577, 0.029150, 0.028283, 0.028080, 0.026334, 0.024469, 0.017677, 0.013783, 0.025071, 0.027642, 0.019206, 0.022514, 0.026160, 0.029408, 0.029583, 0.026832, 0.018758, 0.026923, 0.020605, 0.012133, 0.026319, 0.015293, 0.022153, 0.021382, 0.031172, 0.028301, 0.030924, 0.026623, 0.027068, 0.023467, 0.027621, 0.024808, 0.024279, 0.019080, 0.027685, 0.024708, 0.027600, 0.024534, 0.024797, 0.028009, 0.029839, 0.029211, 0.029031, 0.026101, 0.019186, 0.029222, 0.015159, 0.019795, 0.012674, 0.017339, 0.014625, 0.023460, 0.023955, 0.019176, 0.017681, 0.018288, 0.017404, 0.023503, 0.024255, 0.028827, 0.017032, 0.028076, 0.017066, 0.024314, 0.023311, 0.034059, 0.029586, 0.029647, 0.023057, 0.025407, 0.017737, 0.017154, 0.018832, 0.026276, 0.028637, 0.024706, 0.019158, 0.029836, 0.017045, 0.021232, 0.023923, 0.023548, 0.015161, 0.017387, 0.017610, 0.018174, 0.021269, 0.024875, 0.017432, 0.025381, 0.028516, 
                                  0.029077, 0.019677, 0.017644, 0.017589, 0.025123, 0.019831, 0.026716, 0.020291, 0.027859, 0.025536, 0.025183, 0.014506, 0.012970, 0.024447, 0.015829, 0.012575, 0.026831, 0.022845, 0.029184, 0.029017, 0.021402, 0.025664, 0.025059, 0.023018, 0.021669, 0.027359, 0.019877, 0.021038, 0.026237, 0.027512, 0.018457, 0.022584, 0.034255, 0.029270, 0.024506, 0.020996, 0.022691, 0.028292, 0.023309, 0.018602, 0.025673, 0.018700, 0.022776, 0.023460, 0.016874, 0.020339, 0.021966, 0.021789, 0.024748, 0.022017, 0.026234, 0.019246, 0.024685, 0.025481, 0.020398, 0.025008, 0.019133, 0.032259, 0.027444, 0.017856, 0.019727, 0.022260, 0.016819, 0.018911, 0.021659, 0.025308, 0.025724, 0.018719, 0.017615, 0.024146, 0.029959, 0.018148, 0.017977, 0.020012, 0.017029, 0.019668, 0.023203, 0.019223, 0.024602, 0.026874, 0.028915, 0.022991, 0.021121, 0.028854, 0.022747, 0.021279, 0.022555, 0.018675, 0.021798, 0.021177, 0.017770, 0.026204, 0.019341, 0.028046, 0.017665, 0.026572, 0.015373, 0.014017, 0.016179, 0.020207, 0.024763, 0.021255, 0.024116, 0.020865, 0.023778, 0.016583, 0.022299, 0.022469, 0.025362, 0.017710, 0.018634, 0.019085, 0.025674, 0.024837, 0.019477, 0.014735, 0.014383, 0.023354, 0.023226, 0.015291, 0.017618, 0.014803, 0.019165, 0.018494, 0.013252, 0.017931, 0.018205, 0.025587, 0.028021, 0.022085, 0.016197, 0.028824, 0.018256, 0.028813, 0.016549, 0.013241, 0.019138, 0.016499, 0.015094, 0.016291, 0.026472, 0.023888, 0.019109, 0.015378, 0.015358, 0.014367, 0.025039, 0.024298, 0.028673, 0.025575, 0.021131, 0.022783, 0.025317, 0.015155, 0.022125, 0.017625, 0.019501, 0.028166, 0.021999, 0.015169, 0.021112, 0.022278, 0.030020, 0.024564, 0.028106, 0.023281, 0.017670, 0.016245, 0.023869, 0.027233, 0.014527, 0.022463, 0.023854, 0.021716, 0.026089, 0.031367, 0.024230, 0.016219, 0.030046, 0.026917, 0.022804, 0.031232, 0.033175, 0.031397, 0.020456, 0.025401, 0.030998, 0.015049, 0.018071, 0.011767, 0.021442, 0.023988, 0.025073, 0.013179, 0.020920, 0.026407, 0.020899, 0.015805, 0.013807, 0.020750, 0.012495, 0.027305, 0.029922, 0.030035, 0.027693, 0.029103, 0.026735, 0.030712, 0.019410, 0.055677, 0.021564, 0.027949, 0.019126, 0.016286, 0.024840, 0.025175, 0.026096, 0.028873, 0.020057, 0.028938, 0.032040, 0.025032, 0.020136, 0.026772, 0.025542, 0.026239, 0.019385, 0.021260, 0.023307, 0.026804, 0.027834, 0.030570, 0.028814, 0.029382, 0.031993, 0.042541, 0.027098, 0.027423, 0.016433, 0.016650, 0.027952, 0.024873, 0.030387, 0.028852, 0.019671, 0.021479, 0.027996, 0.022850, 0.021522, 0.032192, 0.023950, 0.026938, 0.032720, 
                                  0.029886, 0.031971, 0.027722, 0.036884, 0.024679, 0.021079, 0.018663, 0.028069, 0.024204, 0.024387, 0.024116, 0.019244, 0.023668, 0.022555, 0.027291, 0.023662, 0.016951, 0.016292, 0.025423, 0.021292, 0.018933, 0.045908, 0.020832, 0.029362, 0.029817, 0.027684, 0.026930, 0.029119, 0.029091, 0.025309, 0.020439, 0.026490, 0.026037, 0.025761, 0.023924, 0.023937, 0.029849, 0.027550, 0.041029, 0.021601, 0.025378, 0.031941, 0.015138, 0.022247, 0.023502, 0.024656, 0.022624, 0.024786, 0.018023, 0.032194, 0.023088, 0.025889, 0.032933, 0.025203, 0.026138, 0.025025, 0.025788, 0.020127, 0.029206, 0.029831, 0.038394, 0.021209, 0.029415, 0.032742, 0.027737, 0.029507, 0.027461, 0.022964, 0.027413, 0.029516, 0.020904, 0.023654, 0.027863, 0.028931, 0.024172, 0.029245, 0.033017, 0.031592, 0.015848, 0.015935, 0.033256, 0.032053, 0.019413, 0.025473, 0.032537, 0.032869, 0.028766, 0.025937, 0.022206, 0.028906, 0.028988, 0.021648, 0.022410, 0.023049, 0.027641, 0.024609)
  
  MeanDNE.Convex <- c(0.017413, 0.025755, 0.025741, 0.021645, 0.021148, 0.021916, 0.025599, 0.024915, 0.024974, 0.021924, 0.024014, 0.022859, 0.024844, 0.025882, 0.021975, 0.026374, 0.029236, 0.020147, 0.020025, 0.021264, 0.023559, 0.022483, 0.023842, 0.024375, 0.022466, 0.022185, 0.024973, 0.022394, 0.018455, 0.018649, 0.021435, 0.021230, 0.022820, 0.027621, 0.027370, 0.018581, 0.021812, 0.020043, 0.023718, 0.021385, 0.024576, 0.021797, 0.021855, 0.023074, 0.022123, 0.022424, 0.020297, 0.022781, 0.021586, 0.020626, 0.023096, 0.018101, 0.020596, 0.021851, 0.015298, 0.020130, 0.017086, 0.017201, 0.017601, 0.016341, 0.021815, 0.014708, 0.019595, 0.022682, 0.023345, 0.017320, 0.023961, 0.024250, 0.022685, 0.021363, 0.022550, 0.022651, 0.023511, 0.021383, 0.022733, 0.019620, 0.020662, 0.024218, 0.022755, 0.021608, 0.019998, 0.019051, 0.020412, 0.021813, 0.024074, 0.023563, 0.024077, 0.020976, 0.020698, 0.022765, 0.022228, 0.022945, 0.021611, 0.022737, 0.022542, 0.026271, 0.019763, 0.017871, 0.022720, 0.020828, 0.023935, 
                      0.025049, 0.019576, 0.018342, 0.017900, 0.017235, 0.018233, 0.020517, 0.020165, 0.020760, 0.016391, 0.018576, 0.019222, 0.022158, 0.017288, 0.020175, 0.019240, 0.019674, 0.020466, 0.019339, 0.019329, 0.017351, 0.017376, 0.014684, 0.018642, 0.017436, 0.020190, 0.021768, 0.021480, 0.021480, 0.017839, 0.018782, 0.017234, 0.019623, 0.018386, 0.033688, 0.030246, 0.017957, 0.015559, 0.021901, 0.016383, 0.015695, 0.021901, 0.022199, 0.022742, 0.022688, 0.020553, 0.022634, 0.022162, 0.017323, 0.018506, 0.024723, 0.024590, 0.017249, 0.019775, 0.022782, 0.020512, 0.017602, 0.020234, 0.019641, 0.018161, 0.017221, 0.018224, 0.018709, 0.021738, 0.013574, 0.019775, 0.020509, 0.017235, 0.017205, 0.017235, 0.020256, 0.023947, 0.018720, 0.018456, 0.020775, 0.019635, 0.020682, 0.019696, 0.018878, 0.017244, 0.017232, 0.019281, 0.017704, 0.019501, 0.019546, 0.020663, 0.020438, 0.018418, 0.016017, 0.021280, 0.023225, 0.020489, 0.021169, 0.020658, 0.021727, 0.021031, 0.016453, 0.019559, 0.019317, 0.020017, 0.022808, 0.024602, 0.020765, 0.024018, 0.024027, 0.017849, 0.021968, 0.020765, 0.021280, 0.018959, 0.021586, 0.021478, 0.018808, 0.021556, 0.020719, 0.019627, 0.022505, 0.020228, 0.015671, 0.018545, 0.024001, 0.019662, 0.023239, 0.021528, 0.020817, 0.018083, 0.021303, 0.018235, 0.016260, 0.022776, 0.021541, 0.018403, 0.021391, 0.021378, 0.019671, 0.018733, 0.018878, 0.021939, 0.019128, 0.023567, 0.021706, 0.028214, 0.020003, 0.021521, 0.017134, 0.022686, 0.022489, 0.023889, 0.020355, 0.016982, 0.018458, 0.021677, 0.020142, 0.021206, 0.017620, 0.021549, 0.021741, 0.022339, 0.019440, 0.023503, 0.020250, 0.025471, 0.021578, 0.018264, 0.021865, 0.021820, 0.022419, 0.021707, 0.020615, 0.026894, 0.026882, 0.019224, 0.024273, 0.021864, 0.023937, 0.023680, 0.022803, 0.020391, 0.022444, 0.018163, 0.018285, 0.017810, 0.021898, 0.022489, 0.022792, 0.023025, 0.022012, 0.023929, 0.018508, 0.021617, 0.024906, 0.022655, 0.021544, 0.021597, 0.020025, 0.021382, 0.021625, 0.021840, 0.025457, 0.021645, 0.021381, 0.023218, 0.021407, 0.022844, 0.023507, 0.020103, 0.021595, 0.020499, 0.021732, 0.017386, 0.017958, 0.021392, 0.025769, 0.021994, 0.018148, 0.021205, 0.018794, 0.018939, 0.019100, 0.021601, 0.022983, 0.019260, 0.024395, 0.019520, 0.019068, 0.018490, 0.021550, 0.024194, 0.022488, 0.021945, 0.019897, 0.022663, 0.019153, 0.018218, 0.021575, 0.022219, 0.021617, 0.021453, 0.021803, 0.016667, 0.018217, 0.022206, 0.024315, 0.019596, 0.017695, 0.018719, 0.018998, 0.020192, 0.023445, 0.021544, 0.023790, 0.021859, 0.019348, 0.020455, 0.018210, 0.020291, 0.024893, 0.018222, 0.021750, 0.022009, 0.020509, 0.021620, 0.021651, 0.018055, 0.018258, 0.025571, 0.018508, 0.018317, 0.019345, 0.023111, 0.022094, 0.019655, 0.021889, 0.021588, 0.021697, 0.021768, 0.019426, 0.021916, 0.021704, 0.019630, 0.024841, 0.021842, 0.020148, 0.020690, 0.017307, 0.025293, 0.021491, 0.019562, 0.023731, 0.021716, 0.020355, 0.020348, 0.022374, 
                      0.018975, 0.023597, 0.021445, 0.019529, 0.020155, 0.020382, 0.020354, 0.021607, 0.021323, 0.025969, 0.019441, 0.022929, 0.024805, 0.021765, 0.021686, 0.017555, 0.022830, 0.020176, 0.021675, 0.023593, 0.019673, 0.018337, 0.019449, 0.022750, 0.021556, 0.021612, 0.016671, 0.017880, 0.022567, 0.022830, 0.019175, 0.018758, 0.021020, 0.017085, 0.019118, 0.020245, 0.021497, 0.022633, 0.021754, 0.019711, 0.020478, 0.021243, 0.019108, 0.021374, 0.017653, 0.020359, 0.018536, 0.022812, 0.020773, 0.018920, 0.022414, 0.018570, 0.021791, 0.018651, 0.021649, 0.015780, 0.018428, 0.016834, 0.020013, 0.021568, 0.022946, 0.021563, 0.023332, 0.022776, 0.017012, 0.021140, 0.023079, 0.021596, 0.018690, 0.017069, 0.018347, 0.022161, 0.022833, 0.017947, 0.017250, 0.017233, 0.019467, 0.019544, 0.015337, 0.018216, 0.018411, 0.020361, 0.017481, 0.018381, 0.016811, 0.018139, 0.021756, 0.016182, 0.024354, 0.018797, 0.020587, 0.018037, 0.025058, 0.018369, 0.017051, 0.017457, 0.019674, 0.019568, 0.019640, 0.021664, 0.022609, 0.019338, 0.020253, 0.017251, 0.017362, 0.024328, 0.021862, 0.021840, 0.021629, 0.020559, 0.022731, 0.021254, 0.019668, 0.021447, 0.021655, 0.017198, 0.020170, 0.018253, 0.016479, 0.020820, 0.023465, 0.021619, 0.023929, 0.021705, 0.019791, 0.018073, 0.018133, 0.019369, 0.021875, 0.019510, 0.018241, 0.024077, 0.024026, 0.025283, 0.021895, 0.023982, 0.019627, 0.024930, 0.024913, 0.024740, 0.027564, 0.024106, 0.024504, 
                      0.017338, 0.026291, 0.025848, 0.017314, 0.020685, 0.018534, 0.020672, 0.021677, 0.025797, 0.018432, 0.018432, 0.022821, 0.019252, 0.018037, 0.017239, 0.019470, 0.018347, 0.024492, 0.023027, 0.023194, 0.019126, 0.019318, 0.020745, 0.023831, 0.020170, 0.022844, 0.021504, 0.028332, 0.018282, 0.018368, 0.021732, 0.022664, 0.023107, 0.023843, 0.023241, 0.020776, 0.023687, 0.026933, 0.024324, 0.024491, 0.025996, 0.021650, 0.019738, 0.020348, 0.021562, 0.023245, 0.021921, 0.026113, 0.021522, 0.020693, 0.023510, 0.028159, 0.021809, 0.021751, 0.018089, 0.018469, 0.022769, 0.020975, 0.026443, 0.021869, 0.021885, 0.021229, 0.022967, 0.021193, 0.021193, 0.026467, 0.018897, 0.024318, 0.027313, 0.025673, 0.021984, 0.023322, 0.026476, 0.022406, 0.024455, 0.018224, 0.024969, 0.026576, 0.021718, 0.023334, 0.026271, 0.022829, 0.021158, 0.021865, 0.024362, 0.017486, 0.017941, 0.022544, 0.019704, 0.020443, 0.030251, 0.020886, 0.023890, 0.023946, 0.022758, 0.021841, 0.021642, 0.020579, 0.020835, 0.021648, 0.023763, 0.020171, 0.022589, 0.021351, 0.023739, 0.023269, 0.023436, 0.027416, 0.019346, 0.022220, 0.021753, 0.019233, 0.017149, 0.024388, 0.020975, 0.020545, 0.023380, 0.021542, 0.024897, 0.021698, 0.023040, 0.024389, 0.019092, 0.021621, 0.024186, 0.017120, 0.022697, 0.020813, 0.021962, 0.031884, 0.022101, 0.020927, 0.024291, 0.027211, 0.021840, 0.019685, 0.022916, 0.022005, 0.021808, 0.025086, 0.022078, 0.019427, 0.023930, 0.023977, 0.022265, 0.024020, 0.029323, 0.019370, 0.019229, 0.027291, 0.021783, 0.019933, 0.023686, 0.026263, 0.026577, 0.024117, 0.021065, 0.021537, 0.020709, 0.020237, 0.021855, 0.018345, 0.020365, 0.024964, 0.023758)
  
  Proportion.DNEunder0.0001 <- c(0.006085, 0.004442, 0.004677, 0.005563, 0.004647, 0.004631, 0.004653, 0.004029, 0.004620, 0.004405, 0.004327, 0.004653, 0.005466, 0.004697, 0.004612, 0.002974, 0.003259, 0.005838, 0.004712, 0.004315, 0.004508, 0.004278, 0.004548, 0.004195, 0.004393, 0.004619, 0.004793, 0.004203, 0.006369, 0.005862, 
                                 0.004124, 0.003781, 0.004590, 0.003958, 0.003635, 0.004992, 0.004542, 0.004673, 0.004378, 0.004621, 0.004562, 0.004277, 0.004976, 0.004169, 0.004776, 0.004501, 0.007008, 0.005346, 0.004732, 0.005227, 0.004363, 0.004574, 0.004555, 0.005018, 0.005184, 0.005417, 0.006943, 0.005709, 0.005151, 0.004811, 0.005084, 0.006128, 0.005838, 0.004696, 0.004330, 0.005910, 0.004061, 0.003725, 0.004897, 0.003989, 0.005200, 0.004195, 0.004455, 0.004378, 0.004119, 0.005175, 0.005035, 0.005168, 0.004442, 0.004915, 0.004252, 0.004806, 0.005329, 0.002444, 0.004060, 0.004472, 0.004003, 0.004789, 0.004311, 0.005011, 0.005327, 0.004412, 0.005403, 0.004504, 0.004612, 0.003519, 0.004024, 0.005428, 0.004839, 0.004870, 0.004187, 0.004100, 0.005199, 0.005001, 0.005782, 0.005080, 0.005385, 0.005420, 0.005709, 0.004328, 0.005749, 0.006232, 0.004137, 0.005149, 0.004992, 0.005550, 0.006140, 0.005734, 0.005110, 0.004044, 0.005040, 0.006257, 0.006190, 0.005654, 0.006208, 0.006591, 0.004194, 0.004538, 0.004424, 0.004424, 0.004856, 0.005631, 0.004818, 0.005934, 0.003911, 0.002784, 0.002680, 0.004734, 0.006778, 0.004303, 0.005997, 0.006317, 0.004303, 0.005923, 0.003941, 0.004969, 0.005691, 0.004192, 0.003887, 0.005061, 0.005871, 0.004743, 0.004016, 0.005472, 0.005383, 0.005200, 0.005228, 0.006178, 0.004286, 0.005323, 0.004805, 0.006411, 0.005316, 0.005715, 0.006105, 0.008081, 0.004697, 0.004603, 0.005367, 0.005407, 0.006493, 0.005782, 0.007231, 0.005900, 0.005926, 0.006473, 0.005692, 0.003745, 0.005789, 0.005084, 0.005169, 0.006383, 0.006063, 0.005507, 0.006954, 0.005491, 0.005323, 0.005404, 0.005850, 0.005795, 0.004762, 0.004363, 0.004830, 0.004318, 0.004671, 0.004963, 0.006092, 0.005904, 0.005722, 0.004154, 0.004098, 0.003955, 0.004737, 0.004076, 0.003618, 0.004001, 0.005505, 0.005368, 0.005076, 0.005448, 0.003566, 0.004334, 0.004394, 0.004496, 0.004171, 0.005870, 0.005488, 0.004783, 0.004514, 0.005758, 0.006333, 0.004324, 0.004490, 0.004684, 0.005149, 0.004373, 0.005290, 0.005117, 0.005968, 0.005386, 0.004409, 0.004697, 0.005298, 0.004229, 0.004308, 0.005174, 0.004612, 0.005044, 0.004149, 0.004880, 0.005177, 0.004204, 0.003112, 0.004618, 0.005787, 0.006069, 0.004342, 0.003993, 0.003438, 0.005317, 0.005050, 0.006296, 0.004922, 0.005927, 0.004410, 0.005532, 0.005183, 0.005473, 0.004654, 0.004310, 0.005721, 0.004218, 0.004536, 0.003680, 0.004664, 0.004539, 0.004336, 0.005735, 0.004336, 0.004083, 0.004190, 0.003750, 0.003746, 0.004999, 0.004959, 0.004630, 0.004180, 0.005164, 0.003784, 0.003870, 0.005960, 0.005888, 0.004964, 0.004098, 0.004826, 0.005115, 0.004456, 0.004399, 0.004511, 0.005210, 0.004762, 0.004730, 0.004438, 
                                 0.004976, 0.005049, 0.004736, 0.004149, 0.005741, 0.004369, 0.004049, 0.004607, 0.005644, 0.004086, 0.003866, 0.004603, 0.004083, 0.004922, 0.005076, 0.005408, 0.004654, 0.006329, 0.006357, 0.006746, 0.004613, 0.004201, 0.004637, 0.005247, 0.005312, 0.004894, 0.005608, 0.005234, 0.005149, 0.004854, 0.005337, 0.004752, 0.005122, 0.004969, 0.006928, 0.004703, 0.004536, 0.004406, 0.004397, 0.004451, 0.005397, 0.005916, 0.005082, 0.005021, 0.005089, 0.004648, 0.004280, 0.005497, 0.005551, 0.004658, 0.004615, 0.005914, 0.005478, 0.005127, 0.004586, 0.005383, 0.005784, 0.005535, 0.004464, 0.005085, 0.004578, 0.004449, 0.005733, 0.006396, 0.004921, 0.005620, 0.004348, 0.004183, 0.004912, 0.005791, 0.005784, 0.006118, 0.005740, 0.004683, 0.005089, 0.005812, 0.004737, 0.004274, 0.004999, 0.005745, 0.005222, 0.005428, 0.006078, 0.005045, 0.004492, 0.004851, 0.005179, 0.004804, 0.004536, 0.004958, 0.005242, 0.005359, 0.003977, 0.004066, 0.005669, 0.005496, 0.004101, 0.004664, 0.005812, 0.005865, 0.004211, 0.005028, 0.004375, 0.004910, 0.005790, 0.005190, 0.005335, 0.005330, 0.004669, 0.004795, 0.004482, 0.006290, 0.004957, 0.004364, 0.005245, 0.004936, 0.005630, 0.004392, 0.006263, 0.004795, 0.005683, 0.005038, 0.005480, 0.005352, 0.005591, 0.005388, 0.005092, 0.005373, 0.005309, 0.004830, 0.004392, 0.004643, 0.004461, 0.005632, 0.004270, 0.004758, 0.005357, 0.004463, 0.004991, 0.004938, 0.004291, 0.004135, 0.004692, 0.005310, 0.005173, 0.005035, 0.005311, 0.005006, 0.004554, 0.005057, 0.004381, 0.005122, 0.004969, 0.005081, 0.005072, 0.005340, 0.005148, 0.006361, 0.005650, 0.005412, 0.004852, 0.005083, 0.005506, 0.004638, 0.004741, 0.005346, 0.004091, 0.005575, 0.005490, 0.005821, 0.005500, 0.005296, 0.004754, 0.004783, 0.005815, 0.005377, 0.007020, 0.005351, 0.005912, 0.005655, 0.005579, 0.005520, 0.005369, 0.005607, 0.005970, 0.005421, 0.005286, 0.004590, 0.004494, 0.004203, 0.004818, 0.005270, 0.005510, 0.004574, 0.006200, 0.005306, 0.006066, 0.005861, 0.005939, 0.005950, 0.005079, 0.004380, 0.005422, 0.005575, 0.005797, 0.005888, 0.004884, 0.004937, 0.004789, 0.004941, 0.004758, 0.004791, 0.003748, 0.005508, 0.005595, 0.005261, 0.005721, 0.005145, 0.005819, 0.006043, 0.004709, 0.004783, 0.004039, 0.003833, 0.006423, 0.004640, 0.005215, 0.004419, 0.005820, 0.005016, 0.005948, 0.005821, 0.004811, 0.004715, 0.003402, 0.003748, 0.003813, 0.005829, 0.004118, 0.003047, 0.004103, 0.004197, 0.003735, 0.004845, 0.005666, 0.004362, 0.003494, 0.006113, 0.005092, 0.006303, 0.003950, 0.005708, 0.004754, 
                                 0.005848, 0.005848, 0.004483, 0.005076, 0.005269, 0.006297, 0.005743, 0.005106, 0.004596, 0.002613, 0.004584, 0.004882, 0.004955, 0.003993, 0.004256, 0.005864, 0.002920, 0.005281, 0.003282, 0.004738, 0.007106, 0.004982, 0.004675, 0.004029, 0.003828, 0.005127, 0.003913, 0.004266, 0.004583, 0.004184, 0.004355, 0.004787, 0.004985, 0.005139, 0.005241, 0.005007, 0.004707, 0.004765, 0.004706, 0.003706, 0.004728, 0.004015, 0.003282, 0.005180, 0.005385, 0.005374, 0.005214, 0.004492, 0.004002, 0.003585, 0.004674, 0.005818, 0.005101, 0.004046, 0.004615, 0.004615, 0.003309, 0.005667, 0.003686, 0.005036, 0.004314, 0.004755, 0.004193, 0.003546, 0.004378, 0.005488, 0.004740, 0.004367, 0.003977, 0.005109, 0.004161, 0.004429, 0.004986, 0.004673, 0.004074, 0.004371, 0.005412, 0.005014, 0.004089, 0.004569, 0.004883, 0.003074, 0.004750, 0.004283, 0.004465, 0.004896, 0.004688, 0.003790, 0.004044, 0.005548, 0.004986, 0.005718, 0.004259, 0.004933, 0.004916, 0.003939, 0.003609, 0.004182, 0.003885, 0.004581, 0.004654, 0.004192, 0.005040, 0.005039, 0.003973, 0.005164, 0.004933, 0.004927, 0.004550, 0.002033, 0.004625, 0.003957, 0.004378, 0.005618, 0.005171, 0.005132, 0.004130, 0.004366, 0.004484, 0.004222, 0.003124, 0.005524, 0.004827, 0.002739, 0.004579, 0.004399, 0.004636, 0.005497, 0.004336, 0.004640, 0.005023, 0.004984, 0.004823, 0.004514, 0.004355, 0.004565, 0.004574, 0.003571, 0.006085, 0.005476, 0.003259, 0.004660, 0.005418, 0.004040, 0.003647, 0.004214, 0.004416, 0.004731, 0.004915, 0.004622, 0.004651, 0.004970, 0.004926, 0.004964, 0.004591, 0.004188)
  
  PCR_Train<-data.frame(Age, MeanDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MeanDNE.Convex, Proportion.DNEunder0.0001)
  PCR_Train
}

#' @examples 
#' PCR_Train