% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps2DNormal.R
\name{ps2DNormal}
\alias{ps2DNormal}
\title{Two-dimensional smoothing scattered (normal) data using P-splines.}
\usage{
ps2DNormal(
  Data,
  Pars = rbind(c(min(Data[, 1]), max(Data[, 1]), 10, 3, 1, 2), c(min(Data[, 2]),
    max(Data[, 2]), 10, 3, 1, 2)),
  XYpred = expand.grid(Data[, 1], Data[, 2])
)
}
\arguments{
\item{Data}{a matrix of 3 columns \code{x, y, z} of equal length;
the response is \code{z}.}

\item{Pars}{a matrix of 2 rows, where the first and second row
sets the P-spline paramters for \code{x} and \code{y}, respectively.
Each row consists of: \code{min max nseg bdeg lambda pord}.
The \code{min} and \code{max} set the ranges, \code{nseg} (default 10)
is the number of evenly spaced segments between \code{min} and \code{max},
\code{bdeg} is the degree of the basis (default 3 for cubic),
\code{lambda} is the (positive) tuning parameter for the penalty (default 1),
\code{pord} is the number for the order of the difference penalty (default 2),}

\item{XYpred}{a matrix with two columns \code{(x,y)} that give the coordinates
of (future) prediction; the default is the data locations.}
}
\value{
\item{coef}{a vector of length \code{(Pars[1,3]+Pars[1,4])*(Pars[2,3]+Pars[2,4])}
of (unfolded) estimated P-spline coefficients.}
\item{fit}{a vector of \code{length(y)} of smooth estimated means (at the \code{x,y} locations).}
\item{pred}{a vector of length \code{nrow(XYpred)} of (future) predictions.}
\item{Pars}{the design and tuning parameters (see arguments above).}
\item{cv}{leave-one-out standard error of prediction or root average PRESS.}
\item{h}{"hat" diagonals of tensor P-spline fit.}
\item{B}{tensor product B-spline basis used for fitting.}
}
\description{
ps2DNormal is used to smooth scattered
(normal) data, with aniosotripic penalization of
tensor product P-splines.
}
\details{
Support functions needed: \code{pspline_fitter}, \code{bbase}, and \code{pspline_2dchecker}.
}
\examples{
library(SemiPar)
library(fields)
library(spam)
library(JOPS)

# Get the data
data(ethanol)
x <- ethanol$C
y <- ethanol$E
z <- ethanol$NOx

# Set parameters for domain
xlo <- 7
xhi <- 19
ylo <- 0.5
yhi <- 1.25

# Set P-spline parameters, fit and compute surface
xpars <- c(xlo, xhi, 10, 3, 3, 1)
ypars <- c(ylo, yhi, 10, 3, 3, 1)
Pars1 <- rbind(xpars, ypars)
fit <- ps2DNormal(cbind(x, y, z), Pars = Pars1)
plot(fit, xlab = "C", ylab = "E")
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\seealso{
ps2DGLM
}
\author{
Paul Eilers and Brian Marx
}
