% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{fr-weighted_score}
\alias{fr-weighted_score}
\title{Calcul d'un score pondéré pour chaque observation}
\arguments{
\item{x}{objet de type \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}.}

\item{pond}{pondération à appliquer au score. Il peut s'agir d'un nombre,
d'un vecteur de nombres, du nom d'une des variables du bilan qualité ou d'une
liste de pondérations pour les objets \code{\link{mQR_matrix}}.}
}
\value{
L'objet en entrée avec le score recalculé
}
\description{
Permet de pondérer un score déjà calculé en fonction de variables.
}
\examples{

# Chemin menant au fichier demetra_m.csv
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extraire le bilan qualité à partir du fichier demetra_m.csv
QR <- extract_QR(demetra_path)

# Calculer le score
QR <- compute_score(QR, n_contrib_score = 2)
print(QR)

# Pondérer le score
QR <- weighted_score(QR, 2)
print(QR)

# Extraire le score pondéré
QR$modalities$score_pond

}
\keyword{internal}
