/*
 * Decompiled with CFR 0.152.
 */
package j4r.lang;

import j4r.util.J4RTranslator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class J4RSystem {
    private static String jreVersion;
    private static String revision;

    static {
        String completeJREVersion = System.getProperty("java.version");
        try {
            jreVersion = completeJREVersion.substring(0, completeJREVersion.indexOf("_"));
            revision = completeJREVersion.substring(completeJREVersion.indexOf("_") + 1);
        }
        catch (Exception e) {
            jreVersion = completeJREVersion;
            revision = "unknown";
        }
    }

    public static String getJavaIOTmpDir() {
        String directory = System.getProperty("java.io.tmpdir");
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            directory = directory.concat(File.separator);
        }
        return directory;
    }

    public static void setLanguageFromMain(String[] args, J4RTranslator.Language defaultLanguage) {
        J4RTranslator.Language language = null;
        List<String> argumentList = Arrays.asList(args);
        if (argumentList.contains("-l")) {
            int indexLanguage = argumentList.indexOf("-l") + 1;
            if (argumentList.size() > indexLanguage) {
                String languageCode = argumentList.get(indexLanguage);
                language = J4RTranslator.Language.getLanguage(languageCode);
            }
        }
        if (language == null && defaultLanguage != null) {
            language = defaultLanguage;
        }
        if (language != null) {
            J4RTranslator.setCurrentLanguage(language);
        }
    }

    public static void setLanguageFromMain(String[] args) {
        J4RSystem.setLanguageFromMain(args, null);
    }

    public static String getJavaArchitecture() {
        return System.getProperty("sun.arch.data.model");
    }

    private static int parseJVMVersion(String jvmVersion) {
        String[] splittedDigits = jvmVersion.split("\\.");
        int firstInteger = Integer.parseInt(splittedDigits[0]);
        if (firstInteger != 1) {
            return firstInteger;
        }
        return Integer.parseInt(splittedDigits[1]);
    }

    public static boolean isCurrentJVMLaterThanThisVersion(String targetJVM, boolean upToThirdDigit) {
        int targetVersion;
        int currentVersion = J4RSystem.parseJVMVersion(J4RSystem.getJVMVersion());
        return currentVersion > (targetVersion = J4RSystem.parseJVMVersion(targetJVM));
    }

    public static boolean isCurrentJVMLaterThanThisVersion(String targetJVM) {
        return J4RSystem.isCurrentJVMLaterThanThisVersion(targetJVM, false);
    }

    public static List<String> setClassicalOptions(String[] args) {
        if (args.length == 0) {
            return new ArrayList<String>();
        }
        String inputString = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            inputString = String.valueOf(inputString) + str + "; ";
            ++n2;
        }
        J4RSystem.setLanguageFromMain(args, J4RTranslator.Language.English);
        return Arrays.asList(args);
    }

    public static String retrieveArgument(String option, List<String> argumentList) {
        if (argumentList.contains(option) && argumentList.indexOf(option) + 1 < argumentList.size()) {
            return argumentList.get(argumentList.indexOf(option) + 1);
        }
        return null;
    }

    public static String getJVMVersion() {
        return jreVersion;
    }

    public static String getJVMRevision() {
        return revision;
    }

    public static boolean isRunningOnWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static List<String> getClassPathURLs() throws Exception {
        URL[] urls;
        if (J4RSystem.isCurrentJVMLaterThanThisVersion("1.8.0")) {
            Object urlClassPath = J4RSystem.getURLClassPathWithJava9andLaterVersions();
            Method met = urlClassPath.getClass().getMethod("getURLs", new Class[0]);
            urls = (URL[])met.invoke(urlClassPath, new Object[0]);
        } else {
            URLClassLoader cl = (URLClassLoader)ClassLoader.getSystemClassLoader();
            urls = cl.getURLs();
        }
        ArrayList<String> urlStrings = new ArrayList<String>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            urlStrings.add(url.toString());
            ++n2;
        }
        return urlStrings;
    }

    public static void addToClassPath(String filename) throws Exception {
        Class<?> targetClass;
        Object target;
        URL thisURL;
        File f = new File(filename);
        if (f.exists()) {
            thisURL = f.toURI().toURL();
            if (J4RSystem.isCurrentJVMLaterThanThisVersion("1.8.0")) {
                target = J4RSystem.getURLClassPathWithJava9andLaterVersions();
                targetClass = target.getClass();
            } else {
                target = ClassLoader.getSystemClassLoader();
                targetClass = target.getClass().getSuperclass();
            }
        } else {
            throw new IOException("The file or directory " + filename + " does not exist!");
        }
        Method met = targetClass.getDeclaredMethod("addURL", URL.class);
        met.setAccessible(true);
        met.invoke(target, thisURL);
    }

    private static final Object getURLClassPathWithJava9andLaterVersions() throws Exception {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Field field = cl.getClass().getDeclaredField("ucp");
        field.setAccessible(true);
        return field.get(cl);
    }
}

