% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ivd2vas.R
\docType{methods}
\name{ivd2vas}
\alias{ivd2vas}
\alias{ivd2vas,IntervalData-method}
\alias{ivd2vas,IntervalList-method}
\alias{ivd2vas,IntervalMatrix-method}
\title{Convert interval-valued data responses to visual-analogue responses}
\usage{
\S4method{ivd2vas}{IntervalData}(x)

\S4method{ivd2vas}{IntervalList}(x)

\S4method{ivd2vas}{IntervalMatrix}(x)
}
\arguments{
\item{x}{an interval-valued data or a list or matrix of interval-valued data.}
}
\value{
Returns the mid-points of the given interval-valued data to be considered as visual analogue scale responses in a questionnaire.
}
\description{
Reduce each interval-valued data information to its mid-point so it
can be considered as a response from a visual analogue scale. That is, given an interval-valued
data \eqn{A} this method returns its mid-point \eqn{\mathrm{mid}~A}.
}
\examples{
## Convert to visual analogue response an interval-valued response
ivd2vas(IntervalData(3, 3.2))

## Convert to visual analogue responses a list of interval-valued responses
ivd2vas(IntervalList(c(3, 8.7), c(3.2, 9)))

## Convert to likert-type response a matrix or dataframe of interval-valued responses
ivd2vas(IntervalMatrix(matrix(c(1, 1.5, 3.8, 4, 2.6, 3, 6, 7), 2, 4, byrow = TRUE)))

}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{plot}()},
\code{\link{show}()}

Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{sum}()},
\code{\link{var}()}

Other IntervalMatrix-method: 
\code{\link{IntervalMatrix-class}},
\code{\link{IntervalMatrix}},
\code{\link{apply}()},
\code{\link{ivd2likert}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
\concept{IntervalList-method}
\concept{IntervalMatrix-method}
