% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{SharedComps}
\alias{SharedComps}
\title{Intersection of clusters across multiple methods}
\usage{
SharedComps(List, nrclusters = NULL, fusionsLog = FALSE,
  weightclust = FALSE, names = NULL)
}
\arguments{
\item{List}{A list of clustering outputs or the output of the
\code{DiffGenes} function. The first element of the list will be used as a
reference in \code{ReorderToReference}.}

\item{nrclusters}{If List is the output several clustering methods, it has
to be provided in how many clusters to cut the dendrograms in. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is FALSE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is FALSE.}

\item{names}{Names of the methods or clusters. Default is NULL.}
}
\value{
A vector containing the shared objects of all listed elements.
}
\description{
The \code{SharedComps} function is an easy way to select the objects that
are shared over clusters of different methods.
}
\examples{

data(fingerprintMat)
data(targetMat)
data(geneMat)
data(GeneInfo)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_F,MCF7_T)
names=c('FP','TP')

Comps=SharedComps(List=L,nrclusters=7,fusionsLog=FALSE,weightclust=FALSE,names=names)


}
