% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ADC}
\alias{ADC}
\title{Aggregated data clustering}
\usage{
ADC(List, distmeasure = "tanimoto", normalize = FALSE, method = NULL,
  clust = "agnes", linkage = "flexible", alpha = 0.625)
}
\arguments{
\item{List}{A list of data matrices of the same type. It is assumed the rows are corresponding with the objects.}

\item{distmeasure}{Choice of metric for the dissimilarity matrix (character). Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to "tanimoto".}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to FALSE. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is NULL.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character). Defaults to "flexible".}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible".}
}
\value{
The returned value is a list with the following three elements.
	\item{AllData}{Fused data matrix of the data matrices}
\item{DistM}{The distance matrix computed from the AllData element}
	\item{Clust}{The resulting clustering}
	The value has class "ADC". The Clust element will be of interest for further applications.
}
\description{
Aggregated Data Clustering (ADC) is a direct clustering multi-source technique. ADC merges the columns of all data sets into a single large data set on which a final clustering is performed.
}
\details{
In order to perform aggregated data clustering, the \code{ADC} function was written. A list of data matrices of the same type (continuous or binary) is required as input which are combined into a single (larger) matrix. Hierarchical clustering is performed
	with the \code{agnes} function and the ward link on the resulting data matrix and an applicable distance measure is indicated by the user.
}
\examples{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)
MCF7_ADC=ADC(List=L,distmeasure="tanimoto",normalize=FALSE,method=NULL,clust="agnes",
linkage="flexible",alpha=0.625)
}
\references{
\insertRef{Fodeh2013}{IntClust}
}
