% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PiW.R
\name{PiW}
\alias{PiW}
\title{Projection onto the standard simplex}
\usage{
PiW(v)
}
\arguments{
\item{v}{Input vector}
}
\value{
A vector in the standard simplex that is closest to the input vector is returned.
}
\description{
The input vector is projected onto the standard simplex, i.e. the set of vectors of the same length as the input vector with non-negative entries that sum to 1.
}
\details{
This is an auxiliary function used by the \code{InspectChangepoint} package.
}
\examples{
v <- rnorm(10)
PiW(v)
}
\references{
Chen, Y. and Ye, X. (2011) Projection onto a simplex. arXiv preprint, arxiv:1101.6081.
}
