/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

class SelectedSparseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseIntMatrix1D(AbstractLongIntMap abstractLongIntMap, int[] nArray) {
        this(nArray.length, abstractLongIntMap, 0, 1, nArray, 0);
    }

    protected SelectedSparseIntMatrix1D(int n, AbstractLongIntMap abstractLongIntMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongIntMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public AbstractLongIntMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    public IntMatrix1D like(int n) {
        return new SparseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, int n2) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (n2 == 0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, n2);
        }
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D selectedSparseIntMatrix1D = (SelectedSparseIntMatrix1D)intMatrix1D;
            return this.elements == selectedSparseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D sparseIntMatrix1D = (SparseIntMatrix1D)intMatrix1D;
            return this.elements == sparseIntMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseIntMatrix1D(this.elements, nArray);
    }
}

