/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleMatrix1DComparator;
import cern.colt.matrix.tdouble.algo.DoubleMatrix2DComparator;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DRand;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DoubleBinFunctions1D;

public class DoubleSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DoubleSorting quickSort = new DoubleSorting();
    public static final DoubleSorting mergeSort = new DoubleSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
            Sorting.mergeSort(nArray, n, n2, intComparator);
        }

        protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
            GenericSorting.mergeSort(n, n2, intComparator, swapper);
        }
    };

    protected DoubleSorting() {
    }

    private static final int compareNaN(double d, double d2) {
        if (d != d) {
            if (d2 != d2) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.parallelQuickSort(nArray, n, n2, intComparator);
    }

    protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort(n, n2, intComparator, swapper);
    }

    public DoubleMatrix1D sort(DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix1D.viewSelection(this.sortIndex(doubleMatrix1D));
    }

    public int[] sortIndex(final DoubleMatrix1D doubleMatrix1D) {
        int[] nArray = new int[(int)doubleMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = null;
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            final double[] dArray = (double[])doubleMatrix1D.elements();
            final int n2 = (int)doubleMatrix1D.index(0);
            final int n3 = doubleMatrix1D.stride();
            intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = n2 + n22 * n3;
                    double d = dArray[n32];
                    double d2 = dArray[n4];
                    if (d != d || d2 != d2) {
                        return DoubleSorting.compareNaN(d, d2);
                    }
                    return d < d2 ? -1 : (d == d2 ? 0 : 1);
                }
            };
        } else {
            intComparator = new IntComparator(){

                public int compare(int n, int n2) {
                    double d = doubleMatrix1D.getQuick(n);
                    double d2 = doubleMatrix1D.getQuick(n2);
                    if (d != d || d2 != d2) {
                        return DoubleSorting.compareNaN(d, d2);
                    }
                    return d < d2 ? -1 : (d == d2 ? 0 : 1);
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public int[] sortIndex(DoubleMatrix1D doubleMatrix1D, IntComparator intComparator) {
        int[] nArray = new int[(int)doubleMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public DoubleMatrix1D sort(DoubleMatrix1D doubleMatrix1D, DoubleComparator doubleComparator) {
        return doubleMatrix1D.viewSelection(this.sortIndex(doubleMatrix1D, doubleComparator));
    }

    public int[] sortIndex(final DoubleMatrix1D doubleMatrix1D, final DoubleComparator doubleComparator) {
        int[] nArray = new int[(int)doubleMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = null;
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            final double[] dArray = (double[])doubleMatrix1D.elements();
            final int n2 = (int)doubleMatrix1D.index(0);
            final int n3 = doubleMatrix1D.stride();
            intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = n2 + n22 * n3;
                    return doubleComparator.compare(dArray[n32], dArray[n4]);
                }
            };
        } else {
            intComparator = new IntComparator(){

                public int compare(int n, int n2) {
                    return doubleComparator.compare(doubleMatrix1D.getQuick(n), doubleMatrix1D.getQuick(n2));
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public DoubleMatrix2D sort(DoubleMatrix2D doubleMatrix2D, final double[] dArray) {
        int n = doubleMatrix2D.rows();
        if (dArray.length != n) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                double d = dArray[n];
                double d2 = dArray[n2];
                if (d != d || d2 != d2) {
                    return DoubleSorting.compareNaN(d, d2);
                }
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
            }
        };
        this.runSort(0, n, intComparator, swapper);
        return doubleMatrix2D.viewSelection(nArray, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D doubleMatrix2D, int n) {
        if (n < 0 || n >= doubleMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n + ", matrix=" + AbstractFormatter.shape(doubleMatrix2D));
        }
        int[] nArray = new int[doubleMatrix2D.rows()];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        final DoubleMatrix1D doubleMatrix1D = doubleMatrix2D.viewColumn(n);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                double d = doubleMatrix1D.getQuick(n);
                double d2 = doubleMatrix1D.getQuick(n2);
                if (d != d || d2 != d2) {
                    return DoubleSorting.compareNaN(d, d2);
                }
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return doubleMatrix2D.viewSelection(nArray, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D doubleMatrix2D, final DoubleMatrix1DComparator doubleMatrix1DComparator) {
        int[] nArray = new int[doubleMatrix2D.rows()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[doubleMatrix2D.rows()];
        int n2 = doubleMatrix1DArray.length;
        while (--n2 >= 0) {
            doubleMatrix1DArray[n2] = doubleMatrix2D.viewRow(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return doubleMatrix1DComparator.compare(doubleMatrix1DArray[n], doubleMatrix1DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return doubleMatrix2D.viewSelection(nArray, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D doubleMatrix2D, DoubleBinFunction1D doubleBinFunction1D) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(1, doubleMatrix2D.rows());
        DoubleBinFunction1D[] doubleBinFunction1DArray = new DoubleBinFunction1D[]{doubleBinFunction1D};
        DoubleStatistic.aggregate(doubleMatrix2D.viewDice(), doubleBinFunction1DArray, doubleMatrix2D2);
        double[] dArray = doubleMatrix2D2.viewRow(0).toArray();
        return this.sort(doubleMatrix2D, dArray);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D doubleMatrix3D, int n, int n2) {
        if (n < 0 || n >= doubleMatrix3D.rows()) {
            throw new IndexOutOfBoundsException("row=" + n + ", matrix=" + AbstractFormatter.shape(doubleMatrix3D));
        }
        if (n2 < 0 || n2 >= doubleMatrix3D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n2 + ", matrix=" + AbstractFormatter.shape(doubleMatrix3D));
        }
        int[] nArray = new int[doubleMatrix3D.slices()];
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n3;
        }
        final DoubleMatrix1D doubleMatrix1D = doubleMatrix3D.viewRow(n).viewColumn(n2);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                double d = doubleMatrix1D.getQuick(n);
                double d2 = doubleMatrix1D.getQuick(n2);
                if (d != d || d2 != d2) {
                    return DoubleSorting.compareNaN(d, d2);
                }
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return doubleMatrix3D.viewSelection(nArray, null, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D doubleMatrix3D, final DoubleMatrix2DComparator doubleMatrix2DComparator) {
        int[] nArray = new int[doubleMatrix3D.slices()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final DoubleMatrix2D[] doubleMatrix2DArray = new DoubleMatrix2D[doubleMatrix3D.slices()];
        int n2 = doubleMatrix2DArray.length;
        while (--n2 >= 0) {
            doubleMatrix2DArray[n2] = doubleMatrix3D.viewSlice(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return doubleMatrix2DComparator.compare(doubleMatrix2DArray[n], doubleMatrix2DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return doubleMatrix3D.viewSelection(nArray, null, null);
    }

    public static void zdemo1() {
        DoubleSorting doubleSorting = quickSort;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.descending(4, 3);
        DoubleMatrix1DComparator doubleMatrix1DComparator = new DoubleMatrix1DComparator(){

            public int compare(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                double d;
                double d2 = doubleMatrix1D.zSum();
                return d2 < (d = doubleMatrix1D2.zSum()) ? -1 : (d2 == d ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + doubleMatrix2D);
        System.out.println("sorted  :" + doubleSorting.sort(doubleMatrix2D, doubleMatrix1DComparator));
    }

    public static void zdemo2() {
        DoubleSorting doubleSorting = quickSort;
        DoubleMatrix3D doubleMatrix3D = DoubleFactory3D.dense.descending(4, 3, 2);
        DoubleMatrix2DComparator doubleMatrix2DComparator = new DoubleMatrix2DComparator(){

            public int compare(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                double d;
                double d2 = doubleMatrix2D.zSum();
                return d2 < (d = doubleMatrix2D2.zSum()) ? -1 : (d2 == d ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + doubleMatrix3D);
        System.out.println("sorted  :" + doubleSorting.sort(doubleMatrix3D, doubleMatrix2DComparator));
    }

    public static void zdemo3() {
        DoubleSorting doubleSorting = quickSort;
        double[] dArray = new double[]{0.5, 1.5, 2.5, 3.5};
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        DoubleComparator doubleComparator = new DoubleComparator(){

            public int compare(double d, double d2) {
                double d3;
                double d4 = Math.sin(d);
                return d4 < (d3 = Math.sin(d2)) ? -1 : (d4 == d3 ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + denseDoubleMatrix1D);
        DoubleMatrix1D doubleMatrix1D = doubleSorting.sort(denseDoubleMatrix1D, doubleComparator);
        System.out.println("sorted  :" + doubleMatrix1D);
        doubleMatrix1D.assign(DoubleFunctions.sin);
        System.out.println("sined  :" + doubleMatrix1D);
    }

    protected static void zdemo4() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] dArray2 = new double[]{0.0, 2.0, 4.0, 6.0};
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(dArray2);
        System.out.println("m1:" + denseDoubleMatrix1D);
        System.out.println("m2:" + denseDoubleMatrix1D2);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(denseDoubleMatrix1D2, DoubleFunctions.pow);
        System.out.println("applied:" + denseDoubleMatrix1D);
    }

    public static void zdemo5(int n, int n2, boolean bl) {
        DoubleSorting doubleSorting = quickSort;
        System.out.println("\n\n");
        System.out.print("now initializing... ");
        Timer timer = new Timer().start();
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(n, n2);
        doubleMatrix2D.assign(new DRand());
        timer.stop().display();
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like();
        timer.reset().start();
        System.out.print("now copying... ");
        doubleMatrix2D2.assign(doubleMatrix2D);
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying subrange... ");
        doubleMatrix2D2.viewPart(0, 0, n, n2).assign(doubleMatrix2D.viewPart(0, 0, n, n2));
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying selected... ");
        doubleMatrix2D2.viewSelection(null, null).assign(doubleMatrix2D.viewSelection(null, null));
        timer.stop().display();
        System.out.print("now sorting - quick version with precomputation... ");
        timer.reset().start();
        doubleMatrix2D = doubleSorting.sort(doubleMatrix2D, DoubleBinFunctions1D.median);
        timer.stop().display();
        if (bl) {
            int n3 = Math.min(n, 5);
            DoubleBinFunction1D[] doubleBinFunction1DArray = new DoubleBinFunction1D[]{DoubleBinFunctions1D.median, DoubleBinFunctions1D.sumLog, DoubleBinFunctions1D.geometricMean};
            String[] stringArray = new String[n3];
            String[] stringArray2 = new String[n2];
            int n4 = n2;
            while (--n4 >= 0) {
                stringArray2[n4] = Integer.toString(n4);
            }
            n4 = n3;
            while (--n4 >= 0) {
                stringArray[n4] = Integer.toString(n4);
            }
            System.out.println("first part of sorted result = \n" + new DoubleFormatter("%G").toTitleString(doubleMatrix2D.viewPart(0, 0, n3, n2), stringArray, stringArray2, null, null, null, doubleBinFunction1DArray));
        }
        System.out.print("now sorting - slow version... ");
        doubleMatrix2D = doubleMatrix2D2;
        DoubleMatrix1DComparator doubleMatrix1DComparator = new DoubleMatrix1DComparator(){

            public int compare(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
                double d;
                double d2 = DoubleStatistic.bin(doubleMatrix1D).median();
                return d2 < (d = DoubleStatistic.bin(doubleMatrix1D2).median()) ? -1 : (d2 == d ? 0 : 1);
            }
        };
        timer.reset().start();
        doubleMatrix2D = doubleSorting.sort(doubleMatrix2D, doubleMatrix1DComparator);
        timer.stop().display();
    }

    public static void zdemo6() {
        double[][] dArrayArray = new double[][]{{3.0, 7.0, 0.0}, {2.0, 1.0, 0.0}, {2.0, 2.0, 0.0}, {1.0, 8.0, 0.0}, {2.0, 5.0, 0.0}, {7.0, 0.0, 0.0}, {2.0, 3.0, 0.0}, {1.0, 0.0, 0.0}, {4.0, 0.0, 0.0}, {2.0, 0.0, 0.0}};
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(dArrayArray);
        System.out.println("\n\nunsorted:" + doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = quickSort.sort(doubleMatrix2D, 1);
        DoubleMatrix2D doubleMatrix2D3 = quickSort.sort(doubleMatrix2D2, 0);
        System.out.println("quick sorted  :" + doubleMatrix2D3);
        doubleMatrix2D2 = mergeSort.sort(doubleMatrix2D, 1);
        doubleMatrix2D3 = mergeSort.sort(doubleMatrix2D2, 0);
        System.out.println("merge sorted  :" + doubleMatrix2D3);
    }

    public static void zdemo7(int n, int n2, boolean bl) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(n, n2);
        doubleMatrix2D.assign(new DRand());
        double[] dArray = doubleMatrix2D.viewColumn(0).toArray();
        double[] dArray2 = doubleMatrix2D.viewColumn(0).toArray();
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(doubleMatrix2D, 0);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(doubleMatrix2D, 0);
        timer.stop().display();
        System.out.print("now quick sorting with simple aggregation... ");
        timer.reset().start();
        quickSort.sort(doubleMatrix2D, dArray);
        timer.stop().display();
        System.out.print("now merge sorting with simple aggregation... ");
        timer.reset().start();
        mergeSort.sort(doubleMatrix2D, dArray2);
        timer.stop().display();
    }

    public static void zdemo8(int n) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.random(n);
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(doubleMatrix1D);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(doubleMatrix1D);
        timer.stop().display();
    }

    public static void main(String[] stringArray) {
        ConcurrencyUtils.setNumberOfThreads(2);
        DoubleSorting.zdemo8(10000000);
        System.exit(0);
    }
}

