/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseDComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new ConcurrentHashMap(n * (n2 / 1000));
    }

    protected SparseDComplexMatrix2D(int n, int n2, ConcurrentHashMap<Long, double[]> concurrentHashMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix2D assign(double[] dArray) {
        if (this.isNoView && dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (!(dComplexMatrix2D instanceof SparseDComplexMatrix2D)) {
            return super.assign(dComplexMatrix2D);
        }
        SparseDComplexMatrix2D sparseDComplexMatrix2D = (SparseDComplexMatrix2D)dComplexMatrix2D;
        if (sparseDComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseDComplexMatrix2D);
        if (this.isNoView && sparseDComplexMatrix2D.isNoView) {
            this.elements.clear();
            this.elements.putAll(sparseDComplexMatrix2D.elements);
            return this;
        }
        return super.assign(dComplexMatrix2D);
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        if (!this.isNoView) {
            return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
        }
        this.checkShape(dComplexMatrix2D);
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond) {
            final double[] dArray = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator;
            if (dArray[0] == 0.0 && dArray[1] == 1.0) {
                return this;
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray2) {
                    SparseDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(SparseDComplexMatrix2D.this.getQuick(n, n2), DComplex.mult(dArray, dArray2)));
                    return dArray2;
                }
            });
            return this;
        }
        return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int n, int n2) {
        double[] dArray = this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
        if (dArray != null) {
            return new double[]{dArray[0], dArray[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedSparseDComplexMatrix2D) {
            SelectedSparseDComplexMatrix2D selectedSparseDComplexMatrix2D = (SelectedSparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedSparseDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof SparseDComplexMatrix2D) {
            SparseDComplexMatrix2D sparseDComplexMatrix2D = (SparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == sparseDComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    @Override
    public DComplexMatrix2D like(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        return new SparseDComplexMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    public synchronized void setQuick(int n, int n2, double[] dArray) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, dArray);
        }
    }

    @Override
    public DComplexMatrix1D vectorize() {
        final SparseDComplexMatrix1D sparseDComplexMatrix1D = new SparseDComplexMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = 0;
                        for (int i = n3; i < n4; ++i) {
                            n = i * SparseDComplexMatrix2D.this.rows;
                            for (int j = 0; j < SparseDComplexMatrix2D.this.rows; ++j) {
                                double[] dArray = SparseDComplexMatrix2D.this.getQuick(j, i);
                                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                                sparseDComplexMatrix1D.setQuick(n++, dArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray = this.getQuick(j, i);
                    if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                    sparseDComplexMatrix1D.setQuick(n5++, dArray);
                }
            }
        }
        return sparseDComplexMatrix1D;
    }

    @Override
    public synchronized void setQuick(int n, int n2, double d, double d2) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new double[]{d, d2});
        }
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        final SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseDComplexMatrix2D.this.columns; ++j) {
                                sparseDoubleMatrix2D.setQuick(i, j, SparseDComplexMatrix2D.this.getQuick(i, j)[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, this.getQuick(i, j)[1]);
                }
            }
        }
        return sparseDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        final SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SparseDComplexMatrix2D.this.columns; ++j) {
                                sparseDoubleMatrix2D.setQuick(i, j, SparseDComplexMatrix2D.this.getQuick(i, j)[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, this.getQuick(i, j)[0]);
                }
            }
        }
        return sparseDoubleMatrix2D;
    }
}

