/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBufferConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer
extends PersistentObject
implements BooleanBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBufferConsumer target;
    protected boolean[] elements;
    protected BooleanArrayList list;
    protected int capacity;
    protected int size;

    public BooleanBuffer(BooleanBufferConsumer booleanBufferConsumer, int n) {
        this.target = booleanBufferConsumer;
        this.capacity = n;
        this.elements = new boolean[n];
        this.list = new BooleanArrayList(this.elements);
        this.size = 0;
    }

    public void add(boolean bl) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = bl;
    }

    public void addAllOf(BooleanArrayList booleanArrayList) {
        int n = booleanArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(booleanArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

