\name{epCA.inference.battery}
\alias{epCA.inference.battery}
\encoding{UTF-8}
\title{
epCA.inference.battery: Inference tests for Correspondence Analysis (CA) via InPosition.
}
\description{
Correspondence Analysis (CA) and a battery of inference tests via InPosition. The battery includes permutation and bootstrap tests.
}
\usage{
epCA.inference.battery(DATA, DESIGN = NULL, make_design_nominal = TRUE, 
	masses = NULL, weights = NULL, hellinger = FALSE, symmetric = TRUE, 
	graphs = TRUE, k = 0, test.iters = 100, critical.value = 2)
}
\arguments{
  \item{DATA}{original data to perform a CA on.}
  \item{DESIGN}{a design matrix to indicate if rows belong to groups.}
  \item{make_design_nominal}{a boolean. If TRUE (default), DESIGN is a vector that indicates groups (and will be dummy-coded). If FALSE, DESIGN is a dummy-coded matrix.}
  \item{masses}{a diagonal matrix or column-vector of masses for the row items.}
  \item{weights}{a diagonal matrix or column-vector of weights for the column it}
  \item{hellinger}{a boolean. If FALSE (default), Chi-square distance will be used. If TRUE, Hellinger distance will be used.}
  \item{symmetric}{a boolean. If TRUE (default) symmetric factor scores for rows and columns are computed. If FALSE, the simplex (column-based) will be returned.}
  \item{graphs}{a boolean. If TRUE (default), graphs and plots are provided (via \code{\link{epGraphs}})}
  \item{k}{number of components to return.}
  \item{test.iters}{number of iterations}
  \item{critical.value}{numeric. A value, analogous to a z- or t-score to be used to determine significance (via bootstrap ratio).}      
}
\details{
	\code{epCA.inference.battery} performs correspondence analysis and inference tests on a data matrix. \cr\cr
	If the expected time to compute the results (based on \code{test.iters}) exceeds 1 minute, you will be asked (via command line) if you want to continue. 
}
\value{
Returns two lists ($Fixed.Data and $Inference.Data). For $Fixed.Data, see \code{\link{epCA}}, \code{\link{coreCA}} for details on the descriptive (fixed-effects) results.

$Inference.Data returns:
\item{components}{Permutation tests of components. p-values ($p.vals) and distributions of eigenvalues ($eigs.perm) for each component}
\item{fj.boots}{Bootstrap tests of measures (columns). See \code{\link{boot.ratio.test}} output details.}
\item{omni}{Permutation tests of components. p-values ($p.val) and distributions of total inertia ($inertia.perm)}
}

\author{
Derek Beaton, Joseph Dunlop, and Hervé Abdi.
}

\seealso{
	\code{\link{epCA}}, \code{\link{epMCA}}, \code{\link{epMCA.inference.battery}}, \code{\link{caChiTest}}
}
\examples{
	##warning: this example takes a while to compute. This is why it is reduced.
	data(authors)
	ca.authors.res <- epCA.inference.battery(authors$ca$data/100)
}
\keyword{ multivariate }
\keyword{ permutation }
\keyword{ bootstrap }