% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIM.R
\name{BIM}
\alias{BIM}
\title{BIM}
\usage{
BIM(xx, yy, nBoost = 3, max_iter = 5, removesmall = FALSE,
  sigstart = 0.02, sigend = 4)
}
\arguments{
\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{nBoost}{number of classifiers in BIM, default to be 3}

\item{max_iter}{maximum number of iteration for IMMIRGATE classifier, default to be 5}

\item{removesmall}{whether remove features with small weights, default to be FALSE}

\item{sigstart}{start of sigma used in algorithm, default to be 0.02}

\item{sigend}{end of sigma used in algorithm, default to be 4}
}
\value{
\item{matrix}{list of matrix weights}

\item{weights}{coefficient vector for classifiers}

\item{sample_wt}{sample weights}
}
\description{
This function performs BIM algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
re<-BIM(xx,yy)

}
\keyword{BIM}
