% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genContours.R
\name{gen_cont}
\alias{gen_cont}
\title{Generate contours}
\usage{
gen_cont(r, pars_r, reg_info, n_gen = NULL, map_pred_r = NULL,
  stat_only = FALSE, mean_only = FALSE, eff_zero = 12.5,
  stat_only_trend = TRUE)
}
\arguments{
\item{r}{integer indicating the number of the region in which the contours
should be generated}

\item{pars_r}{List of parameter information for region r. The list should contain
two elements, \code{muEst} and \code{sigmaEst}, which give
estimates for the \eqn{\mu} and \eqn{\Sigma} parameters used in
generating contours. Typically obtained from the \code{calc_pars}
function}

\item{reg_info}{a \code{reg_info} list (see documentation for \code{reg_info})}

\item{n_gen}{integer specifying the number of contours to be generated, must
be at least 2}

\item{map_pred_r}{output of \code{get_map} function applied to
\code{SpatialPolygons} object corresponding to an intial
forecast (typically a bias-corrected dynamic ensemble forecast)}

\item{stat_only}{boolean indicating that forecast is purely statistical
(no dynamic ensemble model forecast considered)}

\item{mean_only}{boolean indicating that only the mean contour will be
computed rather than distribution}

\item{eff_zero}{how close a generated vector needs to be to zero to be counted as a
zero, defaults to 12.5}

\item{stat_only_trend}{boolean indicating if a trend adjustment should
be applied when \code{stat_only = TRUE}. Defaults to true}
}
\description{
Generate the contours for a particular region given the model prediction
}
\examples{
\dontrun{
#statistical binary, region 1
stat_bin_1 <- gen_cont(r = 1, pars_r = pars_1, reg_info,
                       stat_only = TRUE, mean_only = TRUE)

#statistical probabilistic, region 1, 2 generated contours
stat_prob_1 <- gen_cont(r = 1, pars_r = pars_1, reg_info,
                        n_gen = 2, stat_only = TRUE)

 #hybrid probabilistic, region 1, 2 generated contours
 hybrid_prob_1 <- gen_cont(r = 1, pars_r = pars_1, reg_info,
                           n_gen = 2, map_pred_r = map_curr_1)
 }
}
