% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phe.sd.R
\name{phe.sd}
\alias{phe.sd}
\title{Standardize Phenotypic Values}
\usage{
phe.sd(phe)
}
\arguments{
\item{phe}{matrix. An n*t matrix with n individuals and t traits, denotes the
phenotypic values. The missing value must be coded as NA.}
}
\value{
\item{standardize.phe}{An n*t matrix contains the standardized phenotypic values.}
\item{mu}{A vector with length t contains the averages of the phenotypic values
of the t target traits.}
\item{sd}{A vector with length t contains the standard deviations of the phenotypic
values of the t target traits.}
}
\description{
Standardize the phenotypic values of all the target traits from a training
population. Then, output the standardized phenotypic values, the mean vector,
and the standard deviation vector of the target traits.
}
\examples{
# generate simulated data
phe.test <- data.frame(trait1 = rnorm(50,30,10), trait2 = rnorm(50,10,5), trait3 = rnorm(50,20,20))

# run and output
result <- phe.sd(phe.test)
result
}
