% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.best.R
\name{output.best}
\alias{output.best}
\title{Summary For The Best Individuals}
\usage{
output.best(result, save.pdf = FALSE)
}
\arguments{
\item{result}{list. The data list of the output from simu.GEBVO, simu.GDO,
or simu.GEBVGD.}

\item{save.pdf}{logical. A logical variable, if save.pdf is set to be TRUE,
the pdf file of plots will be saved in the working directory instead of
being shown in the console.}
}
\value{
The GEBV averages of the best individuals among the repetitions over
generations for each trait.
}
\description{
Output the GEBV average curves and the summary statistics for the best
individuals selected over generations.
}
\note{
The figure output contains the plots of GEBV averages of the best individuals
selected over generations for each trait. If save.pdf is set to be TRUE, the
pdf file of plots will be saved in the working directory instead of being
shown in the console.
}
\examples{
# generate simulated data
set.seed(2000)
t1 = rnorm(10, 30, 10)
t2 = rnorm(10, 10, 5)
t3 = NULL
t4 = NULL
t5 = NULL
geno.test <- matrix(sample(c(1, -1), 200, replace = TRUE), 10, 20)
marker.test <- cbind(rep(1:2, each = 10), rep(seq(0, 90, 10), 2))
geno.candidate <- matrix(sample(c(1, -1), 20, replace = TRUE), 20, 20)

# run
result <- simu.GEBVO(t1, t2, t3, t4, t5, geno.test, marker.test, geno.candidate,
nprog = 5, nsele = 10, ngen = 5, nrep = 5)

# summary for the best individuals
output <- output.best(result)
output
}
\references{
Chung PY, Liao CT. 2020. Identification of superior parental lines for
biparental crossing via genomic prediction. PLoS ONE 15(12):e0243159.
}
\seealso{
\code{\link[IPLGP]{simu.GEBVO}}
\code{\link[IPLGP]{simu.GDO}}
\code{\link[IPLGP]{simu.GEBVGD}}
\code{\link[ggplot2]{ggplot}}
}
