% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithms.R
\name{IOH_self_adaptive_GA}
\alias{IOH_self_adaptive_GA}
\alias{self_adaptive_GA}
\title{IOHexperimenter-based wrapper}
\usage{
IOH_self_adaptive_GA(IOHproblem, lambda_ = 1, budget = NULL)

self_adaptive_GA(dimension, obj_func, lambda_ = 10, budget = NULL,
  set_parameters = NULL, target_hit = function() {     FALSE })
}
\arguments{
\item{IOHproblem}{An IOHproblem object}

\item{lambda_}{The size of the offspring}

\item{budget}{How many times the objective function can be evaluated}

\item{dimension}{Dimension of search space}

\item{obj_func}{The evaluation function}

\item{set_parameters}{Function to call to store the value of the registered parameters}

\item{target_hit}{Optional, function which enables early stopping if a target value is reached}
}
\value{
A list containing the location (xopt) and value (fopt) of the optimal value found
}
\description{
For easier use with the IOHexperimenter

A genetic algorithm that controls the mutation rate (strength) using the so-called
self-adaptation mechanism: the mutation rate is firstly perturbated and then the
resulting value is taken to mutate Lambda solution vector. The best solution is
selected along with its mutation rate.
}
\examples{
\donttest{
one_comma_two_EA <- function(IOHproblem) { IOH_self_adaptive_GA(IOHproblem, lambda_=2) }

benchmark_algorithm(one_comma_two_EA, params.track = "Mutation rate",
algorithm.name = "one_comma_two_EA", data.dir = NULL,
algorithm.info = "Using one_comma_two_EA with specific parameter" )
}
}
