% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_to_DAF.R
\name{data_to_DAF}
\alias{data_to_DAF}
\title{DAF File Writer}
\usage{
data_to_DAF(
  obj,
  write_to,
  viewing_pop = "All",
  overwrite = FALSE,
  binary = TRUE,
  endianness = .Platform$endian,
  display_progress = TRUE,
  verbose = FALSE,
  fullname = TRUE,
  cifdir = dirname(obj$fileName),
  ntry = +Inf,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of 'obj$fileName'\cr
-\%p: with first parent directory of 'obj$fileName'\cr
-\%e: with extension of 'obj$fileName' (without leading .)\cr
-\%s: with shortname from 'obj$fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. Note that it has to be a .daf.}

\item{viewing_pop}{Character String. Allow user to change displayed population. Default is 'All'.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.
Note that if TRUE, it will overwrite exported file if path of 'obj$fileName' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file, i.e. generated by IDEAS(R) or INSPIRE(R), will never be overwritten.
Otherwise, you will get an error saying that overwriting original file is not allowed.\cr}

\item{binary}{whether to write object to file in binary mode or not. Default is TRUE.\cr
Note that it can represent a convenient way to make file written in binary mode back-compatible with former version of IDEAS software.\cr
/!\ However unexpected behaviour may happen if features, regions, pops, ... are depending on masks (e.g. AdaptiveErode, Component, LevelSet, Watershed) introduced in newer version of IDEAS software.\cr
/!\ Important please note that conversion from binary to non-binary and back to binary may create some rounding adjustment resulting in some features/image values changes.\cr
Finally, if data originate from FCS, 'binary' will be forced to FALSE.}

\item{endianness}{The endian-ness ("big" or "little") of the target system for the file. Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{fullname}{whether to export daf file with full name of its corresponding cif, if found. Default is TRUE.
If cif can't be found, daf file will be exported with the original cif file name.}

\item{cifdir}{the path of the directory to initially look to cif file. Default is dirname(obj$fileName). Only apply when 'fullname' is set to TRUE.}

\item{ntry}{number of times \code{\link{data_to_DAF}} will be allowed to find corresponding cif file. Default is +Inf. Only apply when 'fullname' is set to TRUE.}

\item{...}{other arguments to be passed.}
}
\value{
It invisibly returns full path of exported file.
}
\description{
Writes an `IFC_data` object to a daf file
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  tmp <- tempdir(check = TRUE)
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  ## add a new population to daf
  dafnew <- data_add_pops(daf, list(buildPopulation(name = "test", type = "T", obj = 0)))
  ## export obj to file using binary mode
  data_to_DAF(obj = dafnew, write_to = paste0(tmp, "\\\\test_bin.daf"),
              overwrite = TRUE, binary = TRUE)
  ## exporting to non binary mode
  data_to_DAF(obj = dafnew, write_to = paste0(tmp, "\\\\test_notbin.daf"),
              overwrite = TRUE, binary = FALSE)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
