% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spade.R
\name{spade}
\alias{spade}
\title{SPADE model with spatial discretization parameters.}
\usage{
spade(formula, location, data, ndisc, methoddisc)
}
\arguments{
\item{formula}{A formula of spatial variables}

\item{location}{A character vector of location names in a data frame}

\item{data}{A data frame of dataset}

\item{ndisc}{A numeric vector of break numbers for respective
explanatory variables}

\item{methoddisc}{A character vector of discretization methods}
}
\value{
A data frame of power of determinants (PD) of individual
variables from SPADE model.
}
\description{
SPADE model with spatial discretization parameters.
}
\examples{
q.spade <- spade(formula = y ~ xa + xb + xc, location = c("lo", "la"),
                 data = sim, ndisc = c(4,6,6), methoddisc = "quantile")

}
