% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_icd_history}
\alias{get_icd_history}
\title{Get ICD history metadata}
\usage{
get_icd_history(years = NULL, icd3 = NULL)
}
\arguments{
\item{years}{Year or years to get (numeric or character vector)}

\item{icd3}{(optional) ICD codes to select (regular expression, matched exactly using grep)}
}
\value{
data.frame, see icd_hist
}
\description{
A utility function to query the \link{icd_meta_transition} table.
}
\details{
Returns a data frame with ICD transition history, consisting of
year, ICD code and label. Optional arguments allow selection of
entries by year or ICD code. This is beneficial because the
entire history is relatively large and rarely required in full.
}
\examples{
get_icd_history(years = 2009:2010, icd3 = "K52")
}
