% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_showchanges.R
\name{icd_showchanges}
\alias{icd_showchanges}
\title{Show historical changes to selected ICD-10-GM codes}
\usage{
icd_showchanges(icd_in, col_icd = "icd_sub")
}
\arguments{
\item{icd_in}{Data frame defining ICD codes of interest}

\item{col_icd}{Column of icd_in containing ICD codes (Default: ICD)}
}
\value{
data.frame with columns YEAR, ICD_CODE, ICD_LABEL and, if specified, DIAG_GROUP
}
\description{
Show all changes in ICD history relating to the
3-digit codes contained in the data.frame icd_in.
The output of icd_expand can be passed directly to this
function to display relevant changes.
}
\examples{
dat_icd <- icd_expand(
   data.frame(ICD_SPEC = c("K52.9")),
   col_icd = "ICD_SPEC",
   year = 2019)
icd_showchanges(dat_icd)

}
\seealso{
\code{\link[=icd_showchanges_icd3]{icd_showchanges_icd3()}} to provide one oe more three-digit codes as input
}
