% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-UserBayesFunctions.R
\name{plot.bayes}
\alias{plot.bayes}
\title{Plotting \code{bayes} Objects}
\usage{
\method{plot}{bayes}(x, iter = NULL, sensitivity = TRUE,
  calculate_criterion = FALSE, sens.control = list(),
  sens.bayes.control = list(), crt.bayes.control = list(),
  silent = FALSE, plot_3d = c("lattice", "rgl"), evolution = FALSE,
  ...)
}
\arguments{
\item{x}{An object of class \code{bayes}.}

\item{iter}{Iteration number. if \code{NULL} (default), it will be set to the last iteration.}

\item{sensitivity}{Logical. If \code{TRUE} (default), the general equivalence theorem is used to check the optimality if the best design in iteration number \code{iter} and the sensitivity function will be plotted.}

\item{calculate_criterion}{Logical. Re-calculate the Bayesian criterion value (maybe with a set of new tuning parameters to be sure of the accuracy of the integral approximation)? Defaults to \code{FALSE}. See 'Details'.}

\item{sens.control}{Control Parameters for Calculating the ELB. For details, see the function \code{\link{sens.control}}.}

\item{sens.bayes.control}{Control parameters to verify general equivalence theorem. For details, see \code{\link{sens.bayes.control}}.
If \code{NULL} (default), it will be set to the  tuning parameters used to create object \code{x}.}

\item{crt.bayes.control}{Control parameters to approximate the integration in the Bayesian criterion at a given design.
 For details, see \code{\link{crt.bayes.control}}.
If \code{NULL} (default), it will be set to the  tuning parameters used to create object \code{x}.}

\item{silent}{Do not print anything? Defaults to \code{FALSE}.}

\item{plot_3d}{Which package should be used to plot the sensitivity function for two-dimensional design space. Defaults to \code{plot_3d = "lattice"}.
Only applicable when \code{sensitivity = TRUE}.}

\item{evolution}{Plot Evolution? Defaults to \code{FALSE}.}

\item{...}{Argument with no further use.}
}
\description{
This function plots the evolution of the ICA algorithm (iteration vs the best (minimum) criterion value at each iteration) and also verifies the optimality of the last obtained design
 using  the general equivalence theorem. It plots the sensitivity function and calculates the ELB for the best design generated  at iteration number \code{iter}.
}
\details{
In addition to verifying the general equivalence theorem,
 this function makes it possible to  re-calculate the criterion value for the output designs using a new (say, more conservative) set of tuning parameters.
 This is useful for  Bayesian optimal designs to assess the robustness of the
 criterion value with respect to different values of the tuning parameters.
 To put it simple, for Bayesian generated designs, the user can re-calculate the
 criterion value for the output design (best design generated in \code{iter}) with different values for  \code{maxEval} and \code{tol} in \code{\link{crt.bayes.control}}
 to verify  that the function \code{hcubature} approximates the integrals to an user-acceptable accuracy. The same also applies for the quadrature methods using different number of nodes.
}
\seealso{
\code{\link{bayes}}, \code{\link{bayescomp}}
}
