% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-UserMinimaxFunctions.R
\name{sensmultiple}
\alias{sensmultiple}
\title{Verifying Optimality of The Multiple Objective Designs for The 4-Parameter Hill Model}
\usage{
sensmultiple(dose, w, minDose, maxDose, inipars, lambda, delta,
  Hill_par = FALSE, sens.minimax.control = list(),
  calculate_criterion = TRUE, plot_sens = TRUE,
  tol = sqrt(.Machine$double.xmin), silent = FALSE)
}
\arguments{
\item{dose}{A vector of design points. It is  either dose values or logarithm of dose values when \code{Hill_par = TRUE}.}

\item{w}{A vector of design weights.}

\item{minDose}{Minimum dose \eqn{D}. For the 4-parameter logistic model, i.e. when \code{Hill_par = FALSE}, it is the minimum of \eqn{log(D)}.}

\item{maxDose}{Maximum dose \eqn{D}. For the 4-parameter logistic model, i.e. when \code{Hill_par = FALSE}, it is the maximum of \eqn{log(D)}.}

\item{inipars}{A vector of initial estimates for the vector of parameters  \eqn{(a, b, c, d)}.
For the 4-parameter logistic model, i.e. when \code{Hill_par = FALSE},
it is  a vector of initial estimates for \eqn{(\theta_1, \theta_2,\theta_3, \theta_4)}.}

\item{lambda}{A vector of relative importance of each of the three criteria,
i.e. \eqn{\lambda = (\lambda_1, \lambda_2, \lambda_3)}.
 Here \eqn{0 < \lambda_i < 1} and  s \eqn{\sum \lambda_i = 1}.}

\item{delta}{Predetermined meaningful value of the minimum effective dose MED.
When \eqn{\delta < 0 }, then \eqn{\theta_2 > 0} or when \eqn{\delta > 0}, then \eqn{\theta_2 < 0}.}

\item{Hill_par}{Hill model parameterization? Defaults to \code{TRUE}.}

\item{sens.minimax.control}{Control parameters to verify the general equivalence theorem. For details, see the function \code{\link{sens.minimax.control}}.}

\item{calculate_criterion}{Calculate the criterion? Defaults to \code{TRUE}.}

\item{plot_sens}{Plot the sensitivity (derivative) function? Defaults to \code{TRUE}.}

\item{tol}{Tolerance for finding the general inverse of the Fisher information matrix. Defaults to \code{.Machine$double.xmin}.}

\item{silent}{Do not print anything? Defaults to \code{FALSE}.}
}
\value{
an object of class \code{sensminimax} that is a list with the following elements:
 \describe{
 \item{\code{type}}{Argument \code{type} that is required for print methods.}
 \item{\code{optima}}{A \code{matrix} that stores all the local optima over the parameter space.
  The cost  (criterion) values are stored in a column named \code{Criterion_Value}.
 The last column (\code{Answering_Set})
  shows if the optimum belongs to the answering set (1) or not (0). See 'Details' of \code{\link{sens.minimax.control}}.
   Only applicable for minimax or standardized maximin designs.}
 \item{\code{mu}}{Probability measure on the answering set.
  Corresponds to the rows of \code{optima} for which the associated row in column \code{Answering_Set} is equal to 1.
   Only applicable for minimax or standardized maximin designs.}
 \item{\code{max_deriv}}{Global maximum of the sensitivity (derivative) function (\eqn{\epsilon} in 'Details').}
 \item{\code{ELB}}{D-efficiency lower bound. Can not be larger than 1. If negative, see 'Note' in \code{\link{sensminimax}} or  \code{\link{sens.minimax.control}}.}
 \item{\code{merge_tol}}{Merging tolerance to create the answering set from the set of all local optima. See 'Details' in \code{\link{sens.minimax.control}}.
  Only applicable for minimax or standardized maximin designs.}
 \item{\code{crtval}}{Criterion value. Compare it with the column \code{Crtiterion_Value} in \code{optima} for minimax and standardized maximin designs.}
 \item{\code{time}}{Used CPU time (rough approximation).}
 }
}
\description{
This function uses general equivalence theorem to verify
the optimality of a multiple objective optimal design found for
 the 4-Parameter Hill model and  the 4-parameter logistic model.
For more details, See Hyun and Wong (2015).
}
\details{
ELB is a measure of  proximity of a design to the optimal design without knowing the latter.
Given a design, let \eqn{\epsilon} be the global maximum
 of the sensitivity (derivative) function over \eqn{x \in \chi}{x belong to \chi}.
ELB is given by \deqn{ELB = p/(p + \epsilon),}
where \eqn{p} is the number of model parameters. Obviously,
calculating ELB requires finding \eqn{\epsilon} and
another optimization problem to be solved.
The tuning parameters of this optimization can be regulated via the argument  \code{\link{sens.minimax.control}}.
See, for more details, Masoudi et al. (2017).
}
\note{
DO NOT use this function to verify  c-optimal designs for estimating 'MED' or 'ED50' (verifying single objective optimal designs) because the results may be unstable.
 The reason is that for the c-optimal criterion the generalized inverse of the Fisher information matrix is not stable and depends
 on the tolerance value (\code{tol}).

 Theoretically, ELB can not be larger than 1. But if so, it may have one of the following reasons:
\itemize{
\item \code{max_deriv} is not a GLOBAL maximum.  Please increase  the value of the parameter \code{maxeval} in \code{\link{sens.minimax.control}} to find the global maximum.
\item The sensitivity function is shifted below the y-axis because
the number of model parameters has not been specified correctly (less value given).
Please specify the correct number of model parameters via argument \code{npar}.
}
}
\examples{
#################################################################
# Verifying optimality of a design for the 4-parameter Hill model
#################################################################

## initial estiamtes for the parameters of the Hill model
a <- 0.008949  # ED50
b <- -1.79 # Hill constant
c <- 0.137 # lower limit
d <- 1.7 # upper limit
# D belongs to c(.001, 1000) ## dose in mg
## Hill parameters are c(a, b, c, d)
# dose, minDose and maxDose vector in mg scale

sensmultiple (dose = c(0.001, 0.009426562, 0.01973041, 999.9974),
              w =   c(0.4806477, 0.40815, 0.06114173, 0.05006055),
              minDose = .001, maxDose = 1000,
              Hill_par = TRUE,
              inipars = c(a, b, c, d),
              lambda = c(0.05, 0.05, .90),
              delta = -1)





\dontshow{

## examples fof using this function for c-optimal designs
# first row second column: c-optimal design for estimating ED50 of the 4-parameter logistic model
sensmultiple (dose = c(log(.001), -4.80, log(1000)),
              w = c(.276, .500, .224),
              minDose = log(.001), maxDose = log(1000),
              inipars =  c(d - c, -b, b * log(a), c),
              lambda = c(0, 1, 0),
              delta = -1)
## criterion value is 1e+24 which will be returned when variance for estimating ED50 is comutationaly negative!
## if we change the tolerance for finding  Moore-Penrose Matrix Inverse to .Machine$double.eps
# when get 2.201179 for the criterion value


sensmultiple (dose = c(-6.907755, -4.664224, -3.925594, 6.907753 ),
              w =   c(0.4806477, 0.40815, 0.06114173, 0.05006055 ),
              minDose = log(.001), maxDose = log(1000),
              inipars = c(d - c, -b, b * log(a), c),
              lambda = c(0.05, 0.05, .90),
              delta = -1)
}
}
\references{
Hyun, S. W., and Wong, W. K. (2015). Multiple-Objective Optimal Designs for Studying the Dose Response Function and Interesting Dose Levels. The international journal of biostatistics, 11(2), 253-271.
}
\seealso{
\code{\link{multiple}}
}
