% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_logistic}
\alias{FIM_logistic}
\title{Fisher Information Matrix for the 2-Parameter Logistic (2PL) Model}
\usage{
FIM_logistic(x, w, param)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(a, b)}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for FIM for the model  \code{~1/(1 + exp(-b *(x - a)))}.
In item response theory (IRT),
\eqn{a} is the item difficulty parameter, \eqn{b} is the item discrimination parameter and \eqn{x} is the person ability parameter.
}
\details{
It can be shown that minimax and standardized D-optimal designs for the 2PL model is symmetric around point
\eqn{a_M = (a^L + a^U)/2}{aM = (aL + aU)/2} where \eqn{a^L}{aL} and \eqn{a^U}{aU} are the
lower bound and upper bound for parameter \eqn{a}, respectively. In \code{\link{ICA.control}},
 arguments \code{sym} and \code{sym_point} can be used to specify \eqn{a_M}{aM} and find accurate symmetric optimal designs.
}
\examples{
FIM_logistic(x = c(1, 2), w = c(.5, .5), param = c(2, 1))
}
