% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_equivalence_on_average.R
\name{equivalence_on_average}
\alias{equivalence_on_average}
\title{Checking the optimality of a given design with respect to the optim-on-the-average  criterion by equivalence theorem.}
\usage{
equivalence_on_average(fimfunc, x, w, lx, ux, prior, param,
  maxeval_equivalence = 6000, plot_sensitivity = TRUE, ...)
}
\arguments{
\item{fimfunc}{Fisher information matrix. Can be the name of the Fisher information matrix from FIM family functions available in this package as a
character string or a function that returns the information matrix. See "Details" of \code{\link{mica}}.}

\item{x}{a vector of design points. When design space is multi-dimensional then \code{x} should be filled dimension by dimension. See "Examples" of \code{\link{mica}}.}

\item{w}{a vector of design weights.}

\item{lx}{lower bound of the design space \eqn{\chi}.}

\item{ux}{upper bound of the design space \eqn{\chi}.}

\item{prior}{a vector of probability measure \eqn{\pi}.}

\item{param}{a matrix contains the value of parameters, i.e. support of \eqn{\pi}. Every row is one parameter.
The number of its rows must be equal to the length of \code{prior}.}

\item{maxeval_equivalence}{maximum number of evaulations (\code{maxeval})  that will be passed to optimization function \code{\link[nloptr]{directL}} to find the maximum of the sensitivity function required for calculating DLB. See "Details" of \code{\link{equivalence}}.}

\item{plot_sensitivity}{logical; sensitivity should be plotted? see "Details" of \code{\link{equivalence}}.}

\item{...}{further argument to be passed to \code{fimfunc}.}
}
\value{
an object of class \code{'equivalence'} that is a list contains:
 \describe{
 \item{\code{max_deriv}}{maximum of the sensitivity function}
 \item{\code{DLB}}{D-efficiency lower bound. If negative, the value of \code{maxeval_equivalence} should be increased to find the global maximum.}
 \item{\code{crtval}}{criterion value.}
 }
}
\description{
Let \eqn{\Theta}  be the set of plausible parameter values and weighted by a probability measure
\eqn{\pi}, the measure having support in the parameter space \eqn{\Theta}, and \eqn{\Psi(\xi, \theta) =|M(\xi, \theta)|}.
A design \eqn{\xi^*}{\xi*} is optimum-on-the-average with respect to prior \eqn{\pi}  if
 the following inequality holds for all \eqn{\boldsymbol{x} \in \chi}{x belong to \chi}
 \deqn{c(\boldsymbol{x}, \pi, \xi^*) = \int_{\pi} tr M^{-1}(\xi^*, \theta)I(\boldsymbol{x}, \theta)\pi(\theta) d(\theta)-p \leq 0,}{
         c(x, \pi, \xi*)  = integration over \pi with integrand tr M^-1(\xi*, \theta)I(x, \theta)\pi(\theta) d(\theta)-p <= 0}
          with equality at all support points of \eqn{\xi^*}{\xi*}.
           Here, \eqn{p} is the number of model parameters.
}
\examples{
equivalence_on_average(fimfunc ="FIM_logistic",lx = -5, ux = 5, x = c(0.2603688, 1, 1.739631),
                      w = c(0.2750147, 0.4499705, 0.2750148),  prior = c(.25, .25, .25, .25),
                      param =  matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2))
}
\seealso{
\code{\link{equivalence}} and \code{\link{equivalence_multiple}}.
}

