% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_power_logistic}
\alias{FIM_power_logistic}
\title{Fisher information matrix for the power logistic model.}
\usage{
FIM_power_logistic(x, w, param, s)
}
\arguments{
\item{x}{vector of design points.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters \eqn{(a, b)}.}

\item{s}{power parameter.}
}
\value{
Fisher information matrix.
}
\description{
The mean of response variable is
 \deqn{f(x; a, b, s) =  \frac{1}{(1 + \exp(-b (x - a)))^s},}{f(x; a, b, s) =  1/(1 + \exp(-b (x - a)))^s,}
}
\details{
There is no analytical solution for the locally D-optimal design. Parameter \eqn{s} must be
passed by \code{...} in most of the functions like \code{\link{mica}}.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_uncomp_inhibition}}
}

