% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{TDh}
\alias{TDh}
\title{Temperature, Function of Density and Enthalpy}
\usage{
TDh(D, h, digits = 9)
}
\arguments{
\item{D}{Density [ kg m3 ]}

\item{h}{Enthaly in [ kJ kg-1 ]}

\item{digits}{Digits of results (optional)}
}
\value{
The Temperature: Temp [ K ] and an Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{TDh(D,h,digits=9)} returns the water temperature, Temp [ K ],
     for given D [kg/m3] and h [ kJ kg-1 ].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
D <- 838.025
h <- 977.181624
T_Dh <- TDh(D,h)
T_Dh

}
