% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PriorsmcmcComposite.R
\name{plot.PriorsmcmcComposite}
\alias{plot.PriorsmcmcComposite}
\title{Plot a prior defined with setPriors function}
\usage{
\method{plot}{PriorsmcmcComposite}(x, parameter = 1, ...)
}
\arguments{
\item{x}{The priors to show}

\item{parameter}{The name or rank of prior to show}

\item{...}{Not used}
}
\value{
A ggplot object
}
\description{
Create a ggplot graph with prior.\cr
The function makes minimal effort to decorate the plot.
}
\details{
plot.PriorsmcmcComposite plot a prior
}
\examples{
\dontrun{
library("HelpersMG")
par <- c(a0=10, a1=2, b2=20, b1=-1)
rules <- rbind(data.frame(Name="^a", Min=0, Max="x*2"), 
              data.frame(Name="^b", Min=0, Max=100))
p <- setPriors(par=par, se=NULL, density="dgamma", rules=rules)
plot(p, parameter="a0")
q <- plot(p, parameter="b1")
q + geom_line(color = "red") + theme_bw() + 
theme(plot.margin=unit(c(2,1,1,1), 'cm'), 
      panel.border = element_blank(), 
      axis.line.x.bottom = element_line(colour = "black"), 
      axis.line.y.left = element_line(colour = "black")) + 
labs(title="Parameter: b1") + theme(plot.title = element_text(hjust = 0.5))
}
}
\seealso{
Other mcmcComposite functions: 
\code{\link{MHalgoGen}()},
\code{\link{as.mcmc.mcmcComposite}()},
\code{\link{as.parameters}()},
\code{\link{as.quantiles}()},
\code{\link{merge.mcmcComposite}()},
\code{\link{plot.mcmcComposite}()},
\code{\link{setPriors}()},
\code{\link{summary.mcmcComposite}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{mcmcComposite functions}
