% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeled.hist.R
\name{modeled.hist}
\alias{modeled.hist}
\title{Return the theoretical value for the histogram bar}
\usage{
modeled.hist(breaks, FUN, ..., sum = 1)
}
\arguments{
\item{breaks}{Vector with the breaks; it can be obtained directly from hist()}

\item{FUN}{Function to be used to integrate the density, ex. pnorm}

\item{...}{Parameters to be used by FUN}

\item{sum}{Total numbers in the histogram; 1 for emperical frequencies}
}
\value{
A list with x (the center of the bar) and y components
}
\description{
Return the theoretical value for the histogram bar based on
a model of distribution.
}
\details{
modeled.hist returns the theoretical value for the histogram bar based on a model of distribution.
}
\examples{
\dontrun{
n <- rnorm(100, mean=10, sd=2)
breaks <- 0:20
hist(n, breaks=breaks)

s <- modeled.hist(breaks=breaks, FUN=pnorm, mean=10, sd=2, sum=100)

points(s$x, s$y, pch=19)
lines(s$x, s$y)

n <- rlnorm(100, meanlog=2, sdlog=0.4)
b <- hist(n, ylim=c(0, 70))

s <- modeled.hist(breaks=b$breaks, FUN=plnorm, meanlog=2, sdlog=0.4, sum=100)

points(s$x, s$y, pch=19)
lines(s$x, s$y)
}
}
\author{
Marc Girondot
}
