## ----setup, warning = FALSE, include = FALSE----------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "auto",
  out.height = "480px",
  fig.width = 7,
  fig.height = 5,
  fig.align = "center",
  fig.retina = 1,
  dpi = 150,
  eval=TRUE,
  tangle = FALSE
)

## ----predictlayer_flow,echo=FALSE,warning=FALSE,fig.show='hold',message=FALSE,fig.cap='Figure 1: The Voronoi tessellation for layer 1 and number of cells 500 with the heat map overlaid for variable z.'----
knitr::include_graphics('./pngs/torus2.png')

## ----eval=TRUE, echo=FALSE----------------------------------------------------
library(knitr)
library(kableExtra)
# Create a data frame with hyperlinks
vignette_data <- data.frame(
  Version_Number = c("v18.05.17", "v18.05.17", "v23.05.16", "v23.10.26", "v24.05.16","v24.08.14", "v25.03.01","v25.08.25"),
  Vignette_Title = c(
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/HVT_vignette.html' target='_blank' rel='noopener noreferrer'>HVT Vignette</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/HVT_model_diagnostics_vignette.html' target='_blank' rel='noopener noreferrer'>HVT Model Diagnostics Vignette</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/Scoring_Cells_with_Layers_using_scoreLayeredHVT.html' target='_blank' rel='noopener noreferrer'>HVT Scoring Cells with Layers using scoreLayeredHVT</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/HVT_Temporal_Analysis.html' target='_blank' rel='noopener noreferrer'>Temporal Analysis and Visualization: Leveraging Time Series Capabilities in HVT",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/LLM_Embeddings_in_HVT.html' target='_blank' rel='noopener noreferrer'>Visualizing LLM Embeddings using HVT</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/Implementation_of_tsne_umap_in_trainHVT.html' target='_blank' rel='noopener noreferrer'>Implementation of t-SNE and UMAP in trainHVT function</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/Dynamic_Forecasting_macroeconomic_data.html' target='_blank' rel='noopener noreferrer'>Dynamic Forecasting of Macroeconomic Time Series Dataset using HVT</a>",
  "<a href='https://rawcdn.githack.com/Mu-Sigma/HVT/master/vignettes/Experimentation_of_hyperparameters_in_msm.html' target='_blank' rel='noopener noreferrer'>Hyperparameter Experimentation for Champion Model Selection in MSM Dynamic Forecasting</a>"
),
  Description = c(
    "Contains the workflow of the functions used for vector quantization and construction of Hierarchical Voronoi Tessellations for data analysis.",
    "Contains demonstrations of functions used to perform model diagnostics and validation for the trained HVT model.",
    "Contains explanations of the functions used for scoring cells with layers based on a sequence of maps using scoreLayeredHVT.",
    "Contains implementations of the functions used for analyzing time series data and creating its state transition flow maps.",
    "Contains implementation and analysis of hierarchical clustering using functions to evaluate and visualize token embeddings generated by OpenAI in 2D Space.",
    "Contains enhancements to the `trainHVT` function with advanced dimensionality reduction techniques such as t-SNE and UMAP, and includes a table of evaluation metrics to improve interpretability.",
    "Contains enhancements to the HVT package for dynamic forecasting using Monte Carlo Simulations of Markov Chain (MSM) on macroeconomic time series dataset.",
    "Contains enhancements to enable strategic selection of the champion model based on the lowest Mean Absolute Error by hyperparameter tuning in msm - dynamic forecasting."
  ),
  stringsAsFactors = FALSE
)
 
# Generate the table
kable(vignette_data, format = "html", 
      col.names = c("Version", "Vignette Title", "Description"), 
      align = "l", escape = FALSE) %>% 
  kable_styling(full_width = TRUE) %>% column_spec(1, width = "15%") 

## ----mlayer_flow,echo=FALSE,warning=FALSE,fig.show='hold',message=FALSE,fig.cap='Figure 2: Data Segregation for scoring based on a sequence of maps using scoreLayeredHVT()'----
knitr::include_graphics('./pngs/scoreLayeredHVT_function.png')

